/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ItemPublicTokenCreateResponse defines the response schema for `/item/public_token/create`")
public class ItemPublicTokenCreateResponse {
    public static final String SERIALIZED_NAME_PUBLIC_TOKEN = "public_token";
    @SerializedName(value="public_token")
    private String publicToken;
    public static final String SERIALIZED_NAME_EXPIRATION = "expiration";
    @SerializedName(value="expiration")
    private OffsetDateTime expiration;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public ItemPublicTokenCreateResponse publicToken(String publicToken) {
        this.publicToken = publicToken;
        return this;
    }

    @ApiModelProperty(required=true, value="A `public_token` for the particular Item corresponding to the specified `access_token`")
    public String getPublicToken() {
        return this.publicToken;
    }

    public void setPublicToken(String publicToken) {
        this.publicToken = publicToken;
    }

    public ItemPublicTokenCreateResponse expiration(OffsetDateTime expiration) {
        this.expiration = expiration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OffsetDateTime getExpiration() {
        return this.expiration;
    }

    public void setExpiration(OffsetDateTime expiration) {
        this.expiration = expiration;
    }

    public ItemPublicTokenCreateResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemPublicTokenCreateResponse itemPublicTokenCreateResponse = (ItemPublicTokenCreateResponse)o;
        return Objects.equals(this.publicToken, itemPublicTokenCreateResponse.publicToken) && Objects.equals(this.expiration, itemPublicTokenCreateResponse.expiration) && Objects.equals(this.requestId, itemPublicTokenCreateResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.publicToken, this.expiration, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemPublicTokenCreateResponse {\n");
        sb.append("    publicToken: ").append(this.toIndentedString(this.publicToken)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

