/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ItemPublicTokenExchangeRequest defines the request schema for `/item/public_token/exchange`")
public class ItemPublicTokenExchangeRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_PUBLIC_TOKEN = "public_token";
    @SerializedName(value="public_token")
    private String publicToken;

    public ItemPublicTokenExchangeRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ItemPublicTokenExchangeRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public ItemPublicTokenExchangeRequest publicToken(String publicToken) {
        this.publicToken = publicToken;
        return this;
    }

    @ApiModelProperty(required=true, value="Your `public_token`, obtained from the Link `onSuccess` callback or `/sandbox/item/public_token/create`.")
    public String getPublicToken() {
        return this.publicToken;
    }

    public void setPublicToken(String publicToken) {
        this.publicToken = publicToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemPublicTokenExchangeRequest itemPublicTokenExchangeRequest = (ItemPublicTokenExchangeRequest)o;
        return Objects.equals(this.clientId, itemPublicTokenExchangeRequest.clientId) && Objects.equals(this.secret, itemPublicTokenExchangeRequest.secret) && Objects.equals(this.publicToken, itemPublicTokenExchangeRequest.publicToken);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.publicToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemPublicTokenExchangeRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    publicToken: ").append(this.toIndentedString(this.publicToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

