/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Information about the last webhook fired for the Item.")
public class ItemStatusLastWebhook {
    public static final String SERIALIZED_NAME_SENT_AT = "sent_at";
    @SerializedName(value="sent_at")
    private OffsetDateTime sentAt;
    public static final String SERIALIZED_NAME_CODE_SENT = "code_sent";
    @SerializedName(value="code_sent")
    private String codeSent;

    public ItemStatusLastWebhook sentAt(OffsetDateTime sentAt) {
        this.sentAt = sentAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="[ISO 8601](https://wikipedia.org/wiki/ISO_8601) timestamp of when the webhook was fired. ")
    public OffsetDateTime getSentAt() {
        return this.sentAt;
    }

    public void setSentAt(OffsetDateTime sentAt) {
        this.sentAt = sentAt;
    }

    public ItemStatusLastWebhook codeSent(String codeSent) {
        this.codeSent = codeSent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The last webhook code sent.")
    public String getCodeSent() {
        return this.codeSent;
    }

    public void setCodeSent(String codeSent) {
        this.codeSent = codeSent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStatusLastWebhook itemStatusLastWebhook = (ItemStatusLastWebhook)o;
        return Objects.equals(this.sentAt, itemStatusLastWebhook.sentAt) && Objects.equals(this.codeSent, itemStatusLastWebhook.codeSent);
    }

    public int hashCode() {
        return Objects.hash(this.sentAt, this.codeSent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemStatusLastWebhook {\n");
        sb.append("    sentAt: ").append(this.toIndentedString(this.sentAt)).append("\n");
        sb.append("    codeSent: ").append(this.toIndentedString(this.codeSent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

