/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Information about the last successful and failed transactions update for the Item.")
public class ItemStatusTransactions {
    public static final String SERIALIZED_NAME_LAST_SUCCESSFUL_UPDATE = "last_successful_update";
    @SerializedName(value="last_successful_update")
    private OffsetDateTime lastSuccessfulUpdate;
    public static final String SERIALIZED_NAME_LAST_FAILED_UPDATE = "last_failed_update";
    @SerializedName(value="last_failed_update")
    private OffsetDateTime lastFailedUpdate;

    public ItemStatusTransactions lastSuccessfulUpdate(OffsetDateTime lastSuccessfulUpdate) {
        this.lastSuccessfulUpdate = lastSuccessfulUpdate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="[ISO 8601](https://wikipedia.org/wiki/ISO_8601) timestamp of the last successful transactions update for the Item. The status will update each time Plaid successfully connects with the institution, regardless of whether any new data is available in the update.")
    public OffsetDateTime getLastSuccessfulUpdate() {
        return this.lastSuccessfulUpdate;
    }

    public void setLastSuccessfulUpdate(OffsetDateTime lastSuccessfulUpdate) {
        this.lastSuccessfulUpdate = lastSuccessfulUpdate;
    }

    public ItemStatusTransactions lastFailedUpdate(OffsetDateTime lastFailedUpdate) {
        this.lastFailedUpdate = lastFailedUpdate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="[ISO 8601](https://wikipedia.org/wiki/ISO_8601) timestamp of the last failed transactions update for the Item. The status will update each time Plaid fails an attempt to connect with the institution, regardless of whether any new data is available in the update.")
    public OffsetDateTime getLastFailedUpdate() {
        return this.lastFailedUpdate;
    }

    public void setLastFailedUpdate(OffsetDateTime lastFailedUpdate) {
        this.lastFailedUpdate = lastFailedUpdate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStatusTransactions itemStatusTransactions = (ItemStatusTransactions)o;
        return Objects.equals(this.lastSuccessfulUpdate, itemStatusTransactions.lastSuccessfulUpdate) && Objects.equals(this.lastFailedUpdate, itemStatusTransactions.lastFailedUpdate);
    }

    public int hashCode() {
        return Objects.hash(this.lastSuccessfulUpdate, this.lastFailedUpdate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemStatusTransactions {\n");
        sb.append("    lastSuccessfulUpdate: ").append(this.toIndentedString(this.lastSuccessfulUpdate)).append("\n");
        sb.append("    lastFailedUpdate: ").append(this.toIndentedString(this.lastFailedUpdate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

