/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A JSON Web Key (JWK) that can be used in conjunction with [JWT libraries](https://jwt.io/#libraries-io) to verify Plaid webhooks")
public class JWKPublicKey {
    public static final String SERIALIZED_NAME_ALG = "alg";
    @SerializedName(value="alg")
    private String alg;
    public static final String SERIALIZED_NAME_CRV = "crv";
    @SerializedName(value="crv")
    private String crv;
    public static final String SERIALIZED_NAME_KID = "kid";
    @SerializedName(value="kid")
    private String kid;
    public static final String SERIALIZED_NAME_KTY = "kty";
    @SerializedName(value="kty")
    private String kty;
    public static final String SERIALIZED_NAME_USE = "use";
    @SerializedName(value="use")
    private String use;
    public static final String SERIALIZED_NAME_X = "x";
    @SerializedName(value="x")
    private String x;
    public static final String SERIALIZED_NAME_Y = "y";
    @SerializedName(value="y")
    private String y;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private Integer createdAt;
    public static final String SERIALIZED_NAME_EXPIRED_AT = "expired_at";
    @SerializedName(value="expired_at")
    private Integer expiredAt;

    public JWKPublicKey alg(String alg) {
        this.alg = alg;
        return this;
    }

    @ApiModelProperty(required=true, value="The alg member identifies the cryptographic algorithm family used with the key.")
    public String getAlg() {
        return this.alg;
    }

    public void setAlg(String alg) {
        this.alg = alg;
    }

    public JWKPublicKey crv(String crv) {
        this.crv = crv;
        return this;
    }

    @ApiModelProperty(required=true, value="The crv member identifies the cryptographic curve used with the key.")
    public String getCrv() {
        return this.crv;
    }

    public void setCrv(String crv) {
        this.crv = crv;
    }

    public JWKPublicKey kid(String kid) {
        this.kid = kid;
        return this;
    }

    @ApiModelProperty(required=true, value="The kid (Key ID) member can be used to match a specific key. This can be used, for instance, to choose among a set of keys within the JWK during key rollover.")
    public String getKid() {
        return this.kid;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    public JWKPublicKey kty(String kty) {
        this.kty = kty;
        return this;
    }

    @ApiModelProperty(required=true, value="The kty (key type) parameter identifies the cryptographic algorithm family used with the key, such as RSA or EC.")
    public String getKty() {
        return this.kty;
    }

    public void setKty(String kty) {
        this.kty = kty;
    }

    public JWKPublicKey use(String use) {
        this.use = use;
        return this;
    }

    @ApiModelProperty(required=true, value="The use (public key use) parameter identifies the intended use of the public key.")
    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public JWKPublicKey x(String x) {
        this.x = x;
        return this;
    }

    @ApiModelProperty(required=true, value="The x member contains the x coordinate for the elliptic curve point, provided as a base64url-encoded string of the coordinate's big endian representation.")
    public String getX() {
        return this.x;
    }

    public void setX(String x) {
        this.x = x;
    }

    public JWKPublicKey y(String y) {
        this.y = y;
        return this;
    }

    @ApiModelProperty(required=true, value="The y member contains the y coordinate for the elliptic curve point, provided as a base64url-encoded string of the coordinate's big endian representation.")
    public String getY() {
        return this.y;
    }

    public void setY(String y) {
        this.y = y;
    }

    public JWKPublicKey createdAt(Integer createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The timestamp when the key was created, in Unix time.")
    public Integer getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Integer createdAt) {
        this.createdAt = createdAt;
    }

    public JWKPublicKey expiredAt(Integer expiredAt) {
        this.expiredAt = expiredAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The timestamp when the key expired, in Unix time.")
    public Integer getExpiredAt() {
        return this.expiredAt;
    }

    public void setExpiredAt(Integer expiredAt) {
        this.expiredAt = expiredAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JWKPublicKey jwKPublicKey = (JWKPublicKey)o;
        return Objects.equals(this.alg, jwKPublicKey.alg) && Objects.equals(this.crv, jwKPublicKey.crv) && Objects.equals(this.kid, jwKPublicKey.kid) && Objects.equals(this.kty, jwKPublicKey.kty) && Objects.equals(this.use, jwKPublicKey.use) && Objects.equals(this.x, jwKPublicKey.x) && Objects.equals(this.y, jwKPublicKey.y) && Objects.equals(this.createdAt, jwKPublicKey.createdAt) && Objects.equals(this.expiredAt, jwKPublicKey.expiredAt);
    }

    public int hashCode() {
        return Objects.hash(this.alg, this.crv, this.kid, this.kty, this.use, this.x, this.y, this.createdAt, this.expiredAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JWKPublicKey {\n");
        sb.append("    alg: ").append(this.toIndentedString(this.alg)).append("\n");
        sb.append("    crv: ").append(this.toIndentedString(this.crv)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    kty: ").append(this.toIndentedString(this.kty)).append("\n");
        sb.append("    use: ").append(this.toIndentedString(this.use)).append("\n");
        sb.append("    x: ").append(this.toIndentedString(this.x)).append("\n");
        sb.append("    y: ").append(this.toIndentedString(this.y)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    expiredAt: ").append(this.toIndentedString(this.expiredAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

