/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Describes the last time each datatype was accessed by an application.")
public class LastDataAccessTimes {
    public static final String SERIALIZED_NAME_APPLICATION_ID = "application_id";
    @SerializedName(value="application_id")
    private String applicationId;
    public static final String SERIALIZED_NAME_ACCOUNT_BALANCE_INFO = "account_balance_info";
    @SerializedName(value="account_balance_info")
    private OffsetDateTime accountBalanceInfo;
    public static final String SERIALIZED_NAME_ACCOUNT_ROUTING_NUMBER = "account_routing_number";
    @SerializedName(value="account_routing_number")
    private OffsetDateTime accountRoutingNumber;
    public static final String SERIALIZED_NAME_CONTACT_DETAILS = "contact_details";
    @SerializedName(value="contact_details")
    private OffsetDateTime contactDetails;
    public static final String SERIALIZED_NAME_TRANSACTIONS = "transactions";
    @SerializedName(value="transactions")
    private OffsetDateTime transactions;
    public static final String SERIALIZED_NAME_CREDIT_AND_LOANS = "credit_and_loans";
    @SerializedName(value="credit_and_loans")
    private OffsetDateTime creditAndLoans;
    public static final String SERIALIZED_NAME_INVESTMENTS = "investments";
    @SerializedName(value="investments")
    private OffsetDateTime investments;
    public static final String SERIALIZED_NAME_PAYROLL_INFO = "payroll_info";
    @SerializedName(value="payroll_info")
    private OffsetDateTime payrollInfo;
    public static final String SERIALIZED_NAME_TRANSACTION_RISK_INFO = "transaction_risk_info";
    @SerializedName(value="transaction_risk_info")
    private OffsetDateTime transactionRiskInfo;

    public LastDataAccessTimes applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the application accessing data.")
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public LastDataAccessTimes accountBalanceInfo(OffsetDateTime accountBalanceInfo) {
        this.accountBalanceInfo = accountBalanceInfo;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2023-02-08T10:00Z", required=true, value="The last time account_balance_info was accessed by this application in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format in UTC. null if never accessed.")
    public OffsetDateTime getAccountBalanceInfo() {
        return this.accountBalanceInfo;
    }

    public void setAccountBalanceInfo(OffsetDateTime accountBalanceInfo) {
        this.accountBalanceInfo = accountBalanceInfo;
    }

    public LastDataAccessTimes accountRoutingNumber(OffsetDateTime accountRoutingNumber) {
        this.accountRoutingNumber = accountRoutingNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2023-02-08T10:00Z", required=true, value="The last time account_routing_number was accessed by this application in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format in UTC. null if never accessed.")
    public OffsetDateTime getAccountRoutingNumber() {
        return this.accountRoutingNumber;
    }

    public void setAccountRoutingNumber(OffsetDateTime accountRoutingNumber) {
        this.accountRoutingNumber = accountRoutingNumber;
    }

    public LastDataAccessTimes contactDetails(OffsetDateTime contactDetails) {
        this.contactDetails = contactDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2023-02-08T10:00Z", required=true, value="The last time contact_details was accessed by this application in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format in UTC. null if never accessed.")
    public OffsetDateTime getContactDetails() {
        return this.contactDetails;
    }

    public void setContactDetails(OffsetDateTime contactDetails) {
        this.contactDetails = contactDetails;
    }

    public LastDataAccessTimes transactions(OffsetDateTime transactions) {
        this.transactions = transactions;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2023-02-08T10:00Z", required=true, value="The last time transactions was accessed by this application in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format in UTC. null if never accessed.")
    public OffsetDateTime getTransactions() {
        return this.transactions;
    }

    public void setTransactions(OffsetDateTime transactions) {
        this.transactions = transactions;
    }

    public LastDataAccessTimes creditAndLoans(OffsetDateTime creditAndLoans) {
        this.creditAndLoans = creditAndLoans;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2023-02-08T10:00Z", required=true, value="The last time credit_and_loans was accessed by this application in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format in UTC. null if never accessed.")
    public OffsetDateTime getCreditAndLoans() {
        return this.creditAndLoans;
    }

    public void setCreditAndLoans(OffsetDateTime creditAndLoans) {
        this.creditAndLoans = creditAndLoans;
    }

    public LastDataAccessTimes investments(OffsetDateTime investments) {
        this.investments = investments;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2023-02-08T10:00Z", required=true, value="The last time investments was accessed by this application in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format in UTC. null if never accessed.")
    public OffsetDateTime getInvestments() {
        return this.investments;
    }

    public void setInvestments(OffsetDateTime investments) {
        this.investments = investments;
    }

    public LastDataAccessTimes payrollInfo(OffsetDateTime payrollInfo) {
        this.payrollInfo = payrollInfo;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2023-02-08T10:00Z", required=true, value="The last time payroll_info was accessed by this application in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format in UTC. null if never accessed.")
    public OffsetDateTime getPayrollInfo() {
        return this.payrollInfo;
    }

    public void setPayrollInfo(OffsetDateTime payrollInfo) {
        this.payrollInfo = payrollInfo;
    }

    public LastDataAccessTimes transactionRiskInfo(OffsetDateTime transactionRiskInfo) {
        this.transactionRiskInfo = transactionRiskInfo;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2023-02-08T10:00Z", required=true, value="The last time transaction_risk_info was accessed by this application in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format in UTC. null if never accessed.")
    public OffsetDateTime getTransactionRiskInfo() {
        return this.transactionRiskInfo;
    }

    public void setTransactionRiskInfo(OffsetDateTime transactionRiskInfo) {
        this.transactionRiskInfo = transactionRiskInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LastDataAccessTimes lastDataAccessTimes = (LastDataAccessTimes)o;
        return Objects.equals(this.applicationId, lastDataAccessTimes.applicationId) && Objects.equals(this.accountBalanceInfo, lastDataAccessTimes.accountBalanceInfo) && Objects.equals(this.accountRoutingNumber, lastDataAccessTimes.accountRoutingNumber) && Objects.equals(this.contactDetails, lastDataAccessTimes.contactDetails) && Objects.equals(this.transactions, lastDataAccessTimes.transactions) && Objects.equals(this.creditAndLoans, lastDataAccessTimes.creditAndLoans) && Objects.equals(this.investments, lastDataAccessTimes.investments) && Objects.equals(this.payrollInfo, lastDataAccessTimes.payrollInfo) && Objects.equals(this.transactionRiskInfo, lastDataAccessTimes.transactionRiskInfo);
    }

    public int hashCode() {
        return Objects.hash(this.applicationId, this.accountBalanceInfo, this.accountRoutingNumber, this.contactDetails, this.transactions, this.creditAndLoans, this.investments, this.payrollInfo, this.transactionRiskInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LastDataAccessTimes {\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("    accountBalanceInfo: ").append(this.toIndentedString(this.accountBalanceInfo)).append("\n");
        sb.append("    accountRoutingNumber: ").append(this.toIndentedString(this.accountRoutingNumber)).append("\n");
        sb.append("    contactDetails: ").append(this.toIndentedString(this.contactDetails)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("    creditAndLoans: ").append(this.toIndentedString(this.creditAndLoans)).append("\n");
        sb.append("    investments: ").append(this.toIndentedString(this.investments)).append("\n");
        sb.append("    payrollInfo: ").append(this.toIndentedString(this.payrollInfo)).append("\n");
        sb.append("    transactionRiskInfo: ").append(this.toIndentedString(this.transactionRiskInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

