/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PlaidError;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The webhook of type `LIABILITIES` and code `DEFAULT_UPDATE` will be fired when new or updated liabilities have been detected on a liabilities item.")
public class LiabilitiesDefaultUpdateWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private PlaidError error;
    public static final String SERIALIZED_NAME_ACCOUNT_IDS_WITH_NEW_LIABILITIES = "account_ids_with_new_liabilities";
    @SerializedName(value="account_ids_with_new_liabilities")
    private List<String> accountIdsWithNewLiabilities = new ArrayList<String>();
    public static final String SERIALIZED_NAME_ACCOUNT_IDS_WITH_UPDATED_LIABILITIES = "account_ids_with_updated_liabilities";
    @SerializedName(value="account_ids_with_updated_liabilities")
    private Map<String, List<String>> accountIdsWithUpdatedLiabilities = new HashMap<String, List<String>>();
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public LiabilitiesDefaultUpdateWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`LIABILITIES`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public LiabilitiesDefaultUpdateWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`DEFAULT_UPDATE`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public LiabilitiesDefaultUpdateWebhook itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `item_id` of the Item associated with this webhook, warning, or error")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public LiabilitiesDefaultUpdateWebhook error(PlaidError error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public PlaidError getError() {
        return this.error;
    }

    public void setError(PlaidError error) {
        this.error = error;
    }

    public LiabilitiesDefaultUpdateWebhook accountIdsWithNewLiabilities(List<String> accountIdsWithNewLiabilities) {
        this.accountIdsWithNewLiabilities = accountIdsWithNewLiabilities;
        return this;
    }

    public LiabilitiesDefaultUpdateWebhook addAccountIdsWithNewLiabilitiesItem(String accountIdsWithNewLiabilitiesItem) {
        this.accountIdsWithNewLiabilities.add(accountIdsWithNewLiabilitiesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of `account_id`'s for accounts that contain new liabilities.'")
    public List<String> getAccountIdsWithNewLiabilities() {
        return this.accountIdsWithNewLiabilities;
    }

    public void setAccountIdsWithNewLiabilities(List<String> accountIdsWithNewLiabilities) {
        this.accountIdsWithNewLiabilities = accountIdsWithNewLiabilities;
    }

    public LiabilitiesDefaultUpdateWebhook accountIdsWithUpdatedLiabilities(Map<String, List<String>> accountIdsWithUpdatedLiabilities) {
        this.accountIdsWithUpdatedLiabilities = accountIdsWithUpdatedLiabilities;
        return this;
    }

    public LiabilitiesDefaultUpdateWebhook putAccountIdsWithUpdatedLiabilitiesItem(String key, List<String> accountIdsWithUpdatedLiabilitiesItem) {
        this.accountIdsWithUpdatedLiabilities.put(key, accountIdsWithUpdatedLiabilitiesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An object with keys of `account_id`'s that are mapped to their respective liabilities fields that changed.  Example: `{ \"XMBvvyMGQ1UoLbKByoMqH3nXMj84ALSdE5B58\": [\"past_amount_due\"] }` ")
    public Map<String, List<String>> getAccountIdsWithUpdatedLiabilities() {
        return this.accountIdsWithUpdatedLiabilities;
    }

    public void setAccountIdsWithUpdatedLiabilities(Map<String, List<String>> accountIdsWithUpdatedLiabilities) {
        this.accountIdsWithUpdatedLiabilities = accountIdsWithUpdatedLiabilities;
    }

    public LiabilitiesDefaultUpdateWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiabilitiesDefaultUpdateWebhook liabilitiesDefaultUpdateWebhook = (LiabilitiesDefaultUpdateWebhook)o;
        return Objects.equals(this.webhookType, liabilitiesDefaultUpdateWebhook.webhookType) && Objects.equals(this.webhookCode, liabilitiesDefaultUpdateWebhook.webhookCode) && Objects.equals(this.itemId, liabilitiesDefaultUpdateWebhook.itemId) && Objects.equals(this.error, liabilitiesDefaultUpdateWebhook.error) && Objects.equals(this.accountIdsWithNewLiabilities, liabilitiesDefaultUpdateWebhook.accountIdsWithNewLiabilities) && Objects.equals(this.accountIdsWithUpdatedLiabilities, liabilitiesDefaultUpdateWebhook.accountIdsWithUpdatedLiabilities) && Objects.equals((Object)this.environment, (Object)liabilitiesDefaultUpdateWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.itemId, this.error, this.accountIdsWithNewLiabilities, this.accountIdsWithUpdatedLiabilities, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LiabilitiesDefaultUpdateWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    accountIdsWithNewLiabilities: ").append(this.toIndentedString(this.accountIdsWithNewLiabilities)).append("\n");
        sb.append("    accountIdsWithUpdatedLiabilities: ").append(this.toIndentedString(this.accountIdsWithUpdatedLiabilities)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

