/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AccountBase;
import com.plaid.client.model.Item;
import com.plaid.client.model.LiabilitiesObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="LiabilitiesGetResponse defines the response schema for `/liabilities/get`")
public class LiabilitiesGetResponse {
    public static final String SERIALIZED_NAME_ACCOUNTS = "accounts";
    @SerializedName(value="accounts")
    private List<AccountBase> accounts = new ArrayList<AccountBase>();
    public static final String SERIALIZED_NAME_ITEM = "item";
    @SerializedName(value="item")
    private Item item;
    public static final String SERIALIZED_NAME_LIABILITIES = "liabilities";
    @SerializedName(value="liabilities")
    private LiabilitiesObject liabilities;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public LiabilitiesGetResponse accounts(List<AccountBase> accounts) {
        this.accounts = accounts;
        return this;
    }

    public LiabilitiesGetResponse addAccountsItem(AccountBase accountsItem) {
        this.accounts.add(accountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of accounts associated with the Item")
    public List<AccountBase> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<AccountBase> accounts) {
        this.accounts = accounts;
    }

    public LiabilitiesGetResponse item(Item item) {
        this.item = item;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public LiabilitiesGetResponse liabilities(LiabilitiesObject liabilities) {
        this.liabilities = liabilities;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public LiabilitiesObject getLiabilities() {
        return this.liabilities;
    }

    public void setLiabilities(LiabilitiesObject liabilities) {
        this.liabilities = liabilities;
    }

    public LiabilitiesGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiabilitiesGetResponse liabilitiesGetResponse = (LiabilitiesGetResponse)o;
        return Objects.equals(this.accounts, liabilitiesGetResponse.accounts) && Objects.equals(this.item, liabilitiesGetResponse.item) && Objects.equals(this.liabilities, liabilitiesGetResponse.liabilities) && Objects.equals(this.requestId, liabilitiesGetResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.accounts, this.item, this.liabilities, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LiabilitiesGetResponse {\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("    item: ").append(this.toIndentedString(this.item)).append("\n");
        sb.append("    liabilities: ").append(this.toIndentedString(this.liabilities)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

