/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CreditCardLiability;
import com.plaid.client.model.MortgageLiability;
import com.plaid.client.model.StudentLoan;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object containing liability accounts")
public class LiabilitiesObject {
    public static final String SERIALIZED_NAME_CREDIT = "credit";
    @SerializedName(value="credit")
    private List<CreditCardLiability> credit = new ArrayList<CreditCardLiability>();
    public static final String SERIALIZED_NAME_MORTGAGE = "mortgage";
    @SerializedName(value="mortgage")
    private List<MortgageLiability> mortgage = new ArrayList<MortgageLiability>();
    public static final String SERIALIZED_NAME_STUDENT = "student";
    @SerializedName(value="student")
    private List<StudentLoan> student = new ArrayList<StudentLoan>();

    public LiabilitiesObject credit(List<CreditCardLiability> credit) {
        this.credit = credit;
        return this;
    }

    public LiabilitiesObject addCreditItem(CreditCardLiability creditItem) {
        this.credit.add(creditItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The credit accounts returned.")
    public List<CreditCardLiability> getCredit() {
        return this.credit;
    }

    public void setCredit(List<CreditCardLiability> credit) {
        this.credit = credit;
    }

    public LiabilitiesObject mortgage(List<MortgageLiability> mortgage) {
        this.mortgage = mortgage;
        return this;
    }

    public LiabilitiesObject addMortgageItem(MortgageLiability mortgageItem) {
        this.mortgage.add(mortgageItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The mortgage accounts returned.")
    public List<MortgageLiability> getMortgage() {
        return this.mortgage;
    }

    public void setMortgage(List<MortgageLiability> mortgage) {
        this.mortgage = mortgage;
    }

    public LiabilitiesObject student(List<StudentLoan> student) {
        this.student = student;
        return this;
    }

    public LiabilitiesObject addStudentItem(StudentLoan studentItem) {
        this.student.add(studentItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The student loan accounts returned.")
    public List<StudentLoan> getStudent() {
        return this.student;
    }

    public void setStudent(List<StudentLoan> student) {
        this.student = student;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiabilitiesObject liabilitiesObject = (LiabilitiesObject)o;
        return Objects.equals(this.credit, liabilitiesObject.credit) && Objects.equals(this.mortgage, liabilitiesObject.mortgage) && Objects.equals(this.student, liabilitiesObject.student);
    }

    public int hashCode() {
        return Objects.hash(this.credit, this.mortgage, this.student);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LiabilitiesObject {\n");
        sb.append("    credit: ").append(this.toIndentedString(this.credit)).append("\n");
        sb.append("    mortgage: ").append(this.toIndentedString(this.mortgage)).append("\n");
        sb.append("    student: ").append(this.toIndentedString(this.student)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

