/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.Address;
import com.plaid.client.model.PSLFStatus;
import com.plaid.client.model.StudentLoanRepaymentModel;
import com.plaid.client.model.StudentLoanStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;

@ApiModel(description="Used to configure Sandbox test data for the Liabilities product")
public class LiabilityOverride {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_PURCHASE_APR = "purchase_apr";
    @SerializedName(value="purchase_apr")
    private Double purchaseApr;
    public static final String SERIALIZED_NAME_CASH_APR = "cash_apr";
    @SerializedName(value="cash_apr")
    private Double cashApr;
    public static final String SERIALIZED_NAME_BALANCE_TRANSFER_APR = "balance_transfer_apr";
    @SerializedName(value="balance_transfer_apr")
    private Double balanceTransferApr;
    public static final String SERIALIZED_NAME_SPECIAL_APR = "special_apr";
    @SerializedName(value="special_apr")
    private Double specialApr;
    public static final String SERIALIZED_NAME_LAST_PAYMENT_AMOUNT = "last_payment_amount";
    @SerializedName(value="last_payment_amount")
    private Double lastPaymentAmount;
    public static final String SERIALIZED_NAME_MINIMUM_PAYMENT_AMOUNT = "minimum_payment_amount";
    @SerializedName(value="minimum_payment_amount")
    private Double minimumPaymentAmount;
    public static final String SERIALIZED_NAME_IS_OVERDUE = "is_overdue";
    @SerializedName(value="is_overdue")
    private Boolean isOverdue;
    public static final String SERIALIZED_NAME_ORIGINATION_DATE = "origination_date";
    @SerializedName(value="origination_date")
    private LocalDate originationDate;
    public static final String SERIALIZED_NAME_PRINCIPAL = "principal";
    @SerializedName(value="principal")
    private Double principal;
    public static final String SERIALIZED_NAME_NOMINAL_APR = "nominal_apr";
    @SerializedName(value="nominal_apr")
    private Double nominalApr;
    public static final String SERIALIZED_NAME_INTEREST_CAPITALIZATION_GRACE_PERIOD_MONTHS = "interest_capitalization_grace_period_months";
    @SerializedName(value="interest_capitalization_grace_period_months")
    private Double interestCapitalizationGracePeriodMonths;
    public static final String SERIALIZED_NAME_REPAYMENT_MODEL = "repayment_model";
    @SerializedName(value="repayment_model")
    private StudentLoanRepaymentModel repaymentModel;
    public static final String SERIALIZED_NAME_EXPECTED_PAYOFF_DATE = "expected_payoff_date";
    @SerializedName(value="expected_payoff_date")
    private LocalDate expectedPayoffDate;
    public static final String SERIALIZED_NAME_GUARANTOR = "guarantor";
    @SerializedName(value="guarantor")
    private String guarantor;
    public static final String SERIALIZED_NAME_IS_FEDERAL = "is_federal";
    @SerializedName(value="is_federal")
    private Boolean isFederal;
    public static final String SERIALIZED_NAME_LOAN_NAME = "loan_name";
    @SerializedName(value="loan_name")
    private String loanName;
    public static final String SERIALIZED_NAME_LOAN_STATUS = "loan_status";
    @SerializedName(value="loan_status")
    private StudentLoanStatus loanStatus;
    public static final String SERIALIZED_NAME_PAYMENT_REFERENCE_NUMBER = "payment_reference_number";
    @SerializedName(value="payment_reference_number")
    private String paymentReferenceNumber;
    public static final String SERIALIZED_NAME_PSLF_STATUS = "pslf_status";
    @SerializedName(value="pslf_status")
    private PSLFStatus pslfStatus;
    public static final String SERIALIZED_NAME_REPAYMENT_PLAN_DESCRIPTION = "repayment_plan_description";
    @SerializedName(value="repayment_plan_description")
    private String repaymentPlanDescription;
    public static final String SERIALIZED_NAME_REPAYMENT_PLAN_TYPE = "repayment_plan_type";
    @SerializedName(value="repayment_plan_type")
    private String repaymentPlanType;
    public static final String SERIALIZED_NAME_SEQUENCE_NUMBER = "sequence_number";
    @SerializedName(value="sequence_number")
    private String sequenceNumber;
    public static final String SERIALIZED_NAME_SERVICER_ADDRESS = "servicer_address";
    @SerializedName(value="servicer_address")
    private Address servicerAddress;

    public LiabilityOverride type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of the liability object, either `credit` or `student`. Mortgages are not currently supported in the custom Sandbox.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public LiabilityOverride purchaseApr(Double purchaseApr) {
        this.purchaseApr = purchaseApr;
        return this;
    }

    @ApiModelProperty(required=true, value="The purchase APR percentage value. For simplicity, this is the only interest rate used to calculate interest charges. Can only be set if `type` is `credit`.")
    public Double getPurchaseApr() {
        return this.purchaseApr;
    }

    public void setPurchaseApr(Double purchaseApr) {
        this.purchaseApr = purchaseApr;
    }

    public LiabilityOverride cashApr(Double cashApr) {
        this.cashApr = cashApr;
        return this;
    }

    @ApiModelProperty(required=true, value="The cash APR percentage value. Can only be set if `type` is `credit`.")
    public Double getCashApr() {
        return this.cashApr;
    }

    public void setCashApr(Double cashApr) {
        this.cashApr = cashApr;
    }

    public LiabilityOverride balanceTransferApr(Double balanceTransferApr) {
        this.balanceTransferApr = balanceTransferApr;
        return this;
    }

    @ApiModelProperty(required=true, value="The balance transfer APR percentage value. Can only be set if `type` is `credit`.")
    public Double getBalanceTransferApr() {
        return this.balanceTransferApr;
    }

    public void setBalanceTransferApr(Double balanceTransferApr) {
        this.balanceTransferApr = balanceTransferApr;
    }

    public LiabilityOverride specialApr(Double specialApr) {
        this.specialApr = specialApr;
        return this;
    }

    @ApiModelProperty(required=true, value="The special APR percentage value. Can only be set if `type` is `credit`.")
    public Double getSpecialApr() {
        return this.specialApr;
    }

    public void setSpecialApr(Double specialApr) {
        this.specialApr = specialApr;
    }

    public LiabilityOverride lastPaymentAmount(Double lastPaymentAmount) {
        this.lastPaymentAmount = lastPaymentAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="Override the `last_payment_amount` field. Can only be set if `type` is `credit`.")
    public Double getLastPaymentAmount() {
        return this.lastPaymentAmount;
    }

    public void setLastPaymentAmount(Double lastPaymentAmount) {
        this.lastPaymentAmount = lastPaymentAmount;
    }

    public LiabilityOverride minimumPaymentAmount(Double minimumPaymentAmount) {
        this.minimumPaymentAmount = minimumPaymentAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="Override the `minimum_payment_amount` field. Can only be set if `type` is `credit` or `student`.")
    public Double getMinimumPaymentAmount() {
        return this.minimumPaymentAmount;
    }

    public void setMinimumPaymentAmount(Double minimumPaymentAmount) {
        this.minimumPaymentAmount = minimumPaymentAmount;
    }

    public LiabilityOverride isOverdue(Boolean isOverdue) {
        this.isOverdue = isOverdue;
        return this;
    }

    @ApiModelProperty(required=true, value="Override the `is_overdue` field")
    public Boolean getIsOverdue() {
        return this.isOverdue;
    }

    public void setIsOverdue(Boolean isOverdue) {
        this.isOverdue = isOverdue;
    }

    public LiabilityOverride originationDate(LocalDate originationDate) {
        this.originationDate = originationDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date on which the loan was initially lent, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) (YYYY-MM-DD) format. Can only be set if `type` is `student`.")
    public LocalDate getOriginationDate() {
        return this.originationDate;
    }

    public void setOriginationDate(LocalDate originationDate) {
        this.originationDate = originationDate;
    }

    public LiabilityOverride principal(Double principal) {
        this.principal = principal;
        return this;
    }

    @ApiModelProperty(required=true, value="The original loan principal. Can only be set if `type` is `student`.")
    public Double getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Double principal) {
        this.principal = principal;
    }

    public LiabilityOverride nominalApr(Double nominalApr) {
        this.nominalApr = nominalApr;
        return this;
    }

    @ApiModelProperty(required=true, value="The interest rate on the loan as a percentage. Can only be set if `type` is `student`.")
    public Double getNominalApr() {
        return this.nominalApr;
    }

    public void setNominalApr(Double nominalApr) {
        this.nominalApr = nominalApr;
    }

    public LiabilityOverride interestCapitalizationGracePeriodMonths(Double interestCapitalizationGracePeriodMonths) {
        this.interestCapitalizationGracePeriodMonths = interestCapitalizationGracePeriodMonths;
        return this;
    }

    @ApiModelProperty(required=true, value="If set, interest capitalization begins at the given number of months after loan origination. By default interest is never capitalized. Can only be set if `type` is `student`.")
    public Double getInterestCapitalizationGracePeriodMonths() {
        return this.interestCapitalizationGracePeriodMonths;
    }

    public void setInterestCapitalizationGracePeriodMonths(Double interestCapitalizationGracePeriodMonths) {
        this.interestCapitalizationGracePeriodMonths = interestCapitalizationGracePeriodMonths;
    }

    public LiabilityOverride repaymentModel(StudentLoanRepaymentModel repaymentModel) {
        this.repaymentModel = repaymentModel;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public StudentLoanRepaymentModel getRepaymentModel() {
        return this.repaymentModel;
    }

    public void setRepaymentModel(StudentLoanRepaymentModel repaymentModel) {
        this.repaymentModel = repaymentModel;
    }

    public LiabilityOverride expectedPayoffDate(LocalDate expectedPayoffDate) {
        this.expectedPayoffDate = expectedPayoffDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Override the `expected_payoff_date` field. Can only be set if `type` is `student`.")
    public LocalDate getExpectedPayoffDate() {
        return this.expectedPayoffDate;
    }

    public void setExpectedPayoffDate(LocalDate expectedPayoffDate) {
        this.expectedPayoffDate = expectedPayoffDate;
    }

    public LiabilityOverride guarantor(String guarantor) {
        this.guarantor = guarantor;
        return this;
    }

    @ApiModelProperty(required=true, value="Override the `guarantor` field. Can only be set if `type` is `student`.")
    public String getGuarantor() {
        return this.guarantor;
    }

    public void setGuarantor(String guarantor) {
        this.guarantor = guarantor;
    }

    public LiabilityOverride isFederal(Boolean isFederal) {
        this.isFederal = isFederal;
        return this;
    }

    @ApiModelProperty(required=true, value="Override the `is_federal` field. Can only be set if `type` is `student`.")
    public Boolean getIsFederal() {
        return this.isFederal;
    }

    public void setIsFederal(Boolean isFederal) {
        this.isFederal = isFederal;
    }

    public LiabilityOverride loanName(String loanName) {
        this.loanName = loanName;
        return this;
    }

    @ApiModelProperty(required=true, value="Override the `loan_name` field. Can only be set if `type` is `student`.")
    public String getLoanName() {
        return this.loanName;
    }

    public void setLoanName(String loanName) {
        this.loanName = loanName;
    }

    public LiabilityOverride loanStatus(StudentLoanStatus loanStatus) {
        this.loanStatus = loanStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public StudentLoanStatus getLoanStatus() {
        return this.loanStatus;
    }

    public void setLoanStatus(StudentLoanStatus loanStatus) {
        this.loanStatus = loanStatus;
    }

    public LiabilityOverride paymentReferenceNumber(String paymentReferenceNumber) {
        this.paymentReferenceNumber = paymentReferenceNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="Override the `payment_reference_number` field. Can only be set if `type` is `student`.")
    public String getPaymentReferenceNumber() {
        return this.paymentReferenceNumber;
    }

    public void setPaymentReferenceNumber(String paymentReferenceNumber) {
        this.paymentReferenceNumber = paymentReferenceNumber;
    }

    public LiabilityOverride pslfStatus(PSLFStatus pslfStatus) {
        this.pslfStatus = pslfStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PSLFStatus getPslfStatus() {
        return this.pslfStatus;
    }

    public void setPslfStatus(PSLFStatus pslfStatus) {
        this.pslfStatus = pslfStatus;
    }

    public LiabilityOverride repaymentPlanDescription(String repaymentPlanDescription) {
        this.repaymentPlanDescription = repaymentPlanDescription;
        return this;
    }

    @ApiModelProperty(required=true, value="Override the `repayment_plan.description` field. Can only be set if `type` is `student`.")
    public String getRepaymentPlanDescription() {
        return this.repaymentPlanDescription;
    }

    public void setRepaymentPlanDescription(String repaymentPlanDescription) {
        this.repaymentPlanDescription = repaymentPlanDescription;
    }

    public LiabilityOverride repaymentPlanType(String repaymentPlanType) {
        this.repaymentPlanType = repaymentPlanType;
        return this;
    }

    @ApiModelProperty(required=true, value="Override the `repayment_plan.type` field. Can only be set if `type` is `student`. Possible values are: `\"extended graduated\"`, `\"extended standard\"`, `\"graduated\"`, `\"income-contingent repayment\"`, `\"income-based repayment\"`, `\"income-sensitive repayment\"`, `\"interest only\"`, `\"other\"`, `\"pay as you earn\"`, `\"revised pay as you earn\"`, `\"standard\"`, or `\"saving on a valuable education\"`.")
    public String getRepaymentPlanType() {
        return this.repaymentPlanType;
    }

    public void setRepaymentPlanType(String repaymentPlanType) {
        this.repaymentPlanType = repaymentPlanType;
    }

    public LiabilityOverride sequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="Override the `sequence_number` field. Can only be set if `type` is `student`.")
    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public LiabilityOverride servicerAddress(Address servicerAddress) {
        this.servicerAddress = servicerAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Address getServicerAddress() {
        return this.servicerAddress;
    }

    public void setServicerAddress(Address servicerAddress) {
        this.servicerAddress = servicerAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiabilityOverride liabilityOverride = (LiabilityOverride)o;
        return Objects.equals(this.type, liabilityOverride.type) && Objects.equals(this.purchaseApr, liabilityOverride.purchaseApr) && Objects.equals(this.cashApr, liabilityOverride.cashApr) && Objects.equals(this.balanceTransferApr, liabilityOverride.balanceTransferApr) && Objects.equals(this.specialApr, liabilityOverride.specialApr) && Objects.equals(this.lastPaymentAmount, liabilityOverride.lastPaymentAmount) && Objects.equals(this.minimumPaymentAmount, liabilityOverride.minimumPaymentAmount) && Objects.equals(this.isOverdue, liabilityOverride.isOverdue) && Objects.equals(this.originationDate, liabilityOverride.originationDate) && Objects.equals(this.principal, liabilityOverride.principal) && Objects.equals(this.nominalApr, liabilityOverride.nominalApr) && Objects.equals(this.interestCapitalizationGracePeriodMonths, liabilityOverride.interestCapitalizationGracePeriodMonths) && Objects.equals(this.repaymentModel, liabilityOverride.repaymentModel) && Objects.equals(this.expectedPayoffDate, liabilityOverride.expectedPayoffDate) && Objects.equals(this.guarantor, liabilityOverride.guarantor) && Objects.equals(this.isFederal, liabilityOverride.isFederal) && Objects.equals(this.loanName, liabilityOverride.loanName) && Objects.equals(this.loanStatus, liabilityOverride.loanStatus) && Objects.equals(this.paymentReferenceNumber, liabilityOverride.paymentReferenceNumber) && Objects.equals(this.pslfStatus, liabilityOverride.pslfStatus) && Objects.equals(this.repaymentPlanDescription, liabilityOverride.repaymentPlanDescription) && Objects.equals(this.repaymentPlanType, liabilityOverride.repaymentPlanType) && Objects.equals(this.sequenceNumber, liabilityOverride.sequenceNumber) && Objects.equals(this.servicerAddress, liabilityOverride.servicerAddress);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.purchaseApr, this.cashApr, this.balanceTransferApr, this.specialApr, this.lastPaymentAmount, this.minimumPaymentAmount, this.isOverdue, this.originationDate, this.principal, this.nominalApr, this.interestCapitalizationGracePeriodMonths, this.repaymentModel, this.expectedPayoffDate, this.guarantor, this.isFederal, this.loanName, this.loanStatus, this.paymentReferenceNumber, this.pslfStatus, this.repaymentPlanDescription, this.repaymentPlanType, this.sequenceNumber, this.servicerAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LiabilityOverride {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    purchaseApr: ").append(this.toIndentedString(this.purchaseApr)).append("\n");
        sb.append("    cashApr: ").append(this.toIndentedString(this.cashApr)).append("\n");
        sb.append("    balanceTransferApr: ").append(this.toIndentedString(this.balanceTransferApr)).append("\n");
        sb.append("    specialApr: ").append(this.toIndentedString(this.specialApr)).append("\n");
        sb.append("    lastPaymentAmount: ").append(this.toIndentedString(this.lastPaymentAmount)).append("\n");
        sb.append("    minimumPaymentAmount: ").append(this.toIndentedString(this.minimumPaymentAmount)).append("\n");
        sb.append("    isOverdue: ").append(this.toIndentedString(this.isOverdue)).append("\n");
        sb.append("    originationDate: ").append(this.toIndentedString(this.originationDate)).append("\n");
        sb.append("    principal: ").append(this.toIndentedString(this.principal)).append("\n");
        sb.append("    nominalApr: ").append(this.toIndentedString(this.nominalApr)).append("\n");
        sb.append("    interestCapitalizationGracePeriodMonths: ").append(this.toIndentedString(this.interestCapitalizationGracePeriodMonths)).append("\n");
        sb.append("    repaymentModel: ").append(this.toIndentedString(this.repaymentModel)).append("\n");
        sb.append("    expectedPayoffDate: ").append(this.toIndentedString(this.expectedPayoffDate)).append("\n");
        sb.append("    guarantor: ").append(this.toIndentedString(this.guarantor)).append("\n");
        sb.append("    isFederal: ").append(this.toIndentedString(this.isFederal)).append("\n");
        sb.append("    loanName: ").append(this.toIndentedString(this.loanName)).append("\n");
        sb.append("    loanStatus: ").append(this.toIndentedString(this.loanStatus)).append("\n");
        sb.append("    paymentReferenceNumber: ").append(this.toIndentedString(this.paymentReferenceNumber)).append("\n");
        sb.append("    pslfStatus: ").append(this.toIndentedString(this.pslfStatus)).append("\n");
        sb.append("    repaymentPlanDescription: ").append(this.toIndentedString(this.repaymentPlanDescription)).append("\n");
        sb.append("    repaymentPlanType: ").append(this.toIndentedString(this.repaymentPlanType)).append("\n");
        sb.append("    sequenceNumber: ").append(this.toIndentedString(this.sequenceNumber)).append("\n");
        sb.append("    servicerAddress: ").append(this.toIndentedString(this.servicerAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

