/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.LinkDeliveryAccount;
import com.plaid.client.model.LinkDeliveryInstitution;
import com.plaid.client.model.LinkDeliveryWebhookCallbackType;
import com.plaid.client.model.LinkEventName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Information related to the callback from the Hosted Link session.")
public class LinkCallbackMetadata {
    public static final String SERIALIZED_NAME_CALLBACK_TYPE = "callback_type";
    @SerializedName(value="callback_type")
    private LinkDeliveryWebhookCallbackType callbackType;
    public static final String SERIALIZED_NAME_EVENT_NAME = "event_name";
    @SerializedName(value="event_name")
    private LinkEventName eventName;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_LINK_SESSION_ID = "link_session_id";
    @SerializedName(value="link_session_id")
    private String linkSessionId;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;
    public static final String SERIALIZED_NAME_INSTITUTION = "institution";
    @SerializedName(value="institution")
    private LinkDeliveryInstitution institution;
    public static final String SERIALIZED_NAME_ACCOUNTS = "accounts";
    @SerializedName(value="accounts")
    private List<LinkDeliveryAccount> accounts = null;

    public LinkCallbackMetadata callbackType(LinkDeliveryWebhookCallbackType callbackType) {
        this.callbackType = callbackType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkDeliveryWebhookCallbackType getCallbackType() {
        return this.callbackType;
    }

    public void setCallbackType(LinkDeliveryWebhookCallbackType callbackType) {
        this.callbackType = callbackType;
    }

    public LinkCallbackMetadata eventName(LinkEventName eventName) {
        this.eventName = eventName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkEventName getEventName() {
        return this.eventName;
    }

    public void setEventName(LinkEventName eventName) {
        this.eventName = eventName;
    }

    public LinkCallbackMetadata status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates where in the flow the Link user exited")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public LinkCallbackMetadata linkSessionId(String linkSessionId) {
        this.linkSessionId = linkSessionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique identifier associated with a user's actions and events through the Link flow. Include this identifier when opening a support ticket for faster turnaround.")
    public String getLinkSessionId() {
        return this.linkSessionId;
    }

    public void setLinkSessionId(String linkSessionId) {
        this.linkSessionId = linkSessionId;
    }

    public LinkCallbackMetadata requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The request ID for the last request made by Link. This can be shared with Plaid Support to expedite investigation.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public LinkCallbackMetadata institution(LinkDeliveryInstitution institution) {
        this.institution = institution;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkDeliveryInstitution getInstitution() {
        return this.institution;
    }

    public void setInstitution(LinkDeliveryInstitution institution) {
        this.institution = institution;
    }

    public LinkCallbackMetadata accounts(List<LinkDeliveryAccount> accounts) {
        this.accounts = accounts;
        return this;
    }

    public LinkCallbackMetadata addAccountsItem(LinkDeliveryAccount accountsItem) {
        if (this.accounts == null) {
            this.accounts = new ArrayList<LinkDeliveryAccount>();
        }
        this.accounts.add(accountsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of accounts attached to the connected Item. If Account Select is enabled via the developer dashboard, accounts will only include selected accounts.")
    public List<LinkDeliveryAccount> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<LinkDeliveryAccount> accounts) {
        this.accounts = accounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkCallbackMetadata linkCallbackMetadata = (LinkCallbackMetadata)o;
        return Objects.equals((Object)this.callbackType, (Object)linkCallbackMetadata.callbackType) && Objects.equals((Object)this.eventName, (Object)linkCallbackMetadata.eventName) && Objects.equals(this.status, linkCallbackMetadata.status) && Objects.equals(this.linkSessionId, linkCallbackMetadata.linkSessionId) && Objects.equals(this.requestId, linkCallbackMetadata.requestId) && Objects.equals(this.institution, linkCallbackMetadata.institution) && Objects.equals(this.accounts, linkCallbackMetadata.accounts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.callbackType, this.eventName, this.status, this.linkSessionId, this.requestId, this.institution, this.accounts});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkCallbackMetadata {\n");
        sb.append("    callbackType: ").append(this.toIndentedString((Object)this.callbackType)).append("\n");
        sb.append("    eventName: ").append(this.toIndentedString((Object)this.eventName)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    linkSessionId: ").append(this.toIndentedString(this.linkSessionId)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    institution: ").append(this.toIndentedString(this.institution)).append("\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

