/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.LinkDeliveryVerificationStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Information related to account attached to the connected Item")
public class LinkDeliveryAccount {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_MASK = "mask";
    @SerializedName(value="mask")
    private String mask;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_SUBTYPE = "subtype";
    @SerializedName(value="subtype")
    private String subtype;
    public static final String SERIALIZED_NAME_VERIFICATION_STATUS = "verification_status";
    @SerializedName(value="verification_status")
    private LinkDeliveryVerificationStatus verificationStatus;
    public static final String SERIALIZED_NAME_CLASS_TYPE = "class_type";
    @SerializedName(value="class_type")
    private String classType;

    public LinkDeliveryAccount id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Plaid `account_id`")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LinkDeliveryAccount name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The official account name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LinkDeliveryAccount mask(String mask) {
        this.mask = mask;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The last 2-4 alphanumeric characters of an account's official account number. Note that the mask may be non-unique between an Item's accounts. It may also not match the mask that the bank displays to the user.")
    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public LinkDeliveryAccount type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account type. See the [Account schema](https://plaid.com/docs/api/accounts/#account-type-schema) for a full list of possible values")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public LinkDeliveryAccount subtype(String subtype) {
        this.subtype = subtype;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account subtype. See the [Account schema](https://plaid.com/docs/api/accounts/#account-type-schema) for a full list of possible values")
    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public LinkDeliveryAccount verificationStatus(LinkDeliveryVerificationStatus verificationStatus) {
        this.verificationStatus = verificationStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkDeliveryVerificationStatus getVerificationStatus() {
        return this.verificationStatus;
    }

    public void setVerificationStatus(LinkDeliveryVerificationStatus verificationStatus) {
        this.verificationStatus = verificationStatus;
    }

    public LinkDeliveryAccount classType(String classType) {
        this.classType = classType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If micro-deposit verification is being used, indicates whether the account being verified is a `business` or `personal` account.")
    public String getClassType() {
        return this.classType;
    }

    public void setClassType(String classType) {
        this.classType = classType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkDeliveryAccount linkDeliveryAccount = (LinkDeliveryAccount)o;
        return Objects.equals(this.id, linkDeliveryAccount.id) && Objects.equals(this.name, linkDeliveryAccount.name) && Objects.equals(this.mask, linkDeliveryAccount.mask) && Objects.equals(this.type, linkDeliveryAccount.type) && Objects.equals(this.subtype, linkDeliveryAccount.subtype) && Objects.equals((Object)this.verificationStatus, (Object)linkDeliveryAccount.verificationStatus) && Objects.equals(this.classType, linkDeliveryAccount.classType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.mask, this.type, this.subtype, this.verificationStatus, this.classType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkDeliveryAccount {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    mask: ").append(this.toIndentedString(this.mask)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    subtype: ").append(this.toIndentedString(this.subtype)).append("\n");
        sb.append("    verificationStatus: ").append(this.toIndentedString((Object)this.verificationStatus)).append("\n");
        sb.append("    classType: ").append(this.toIndentedString(this.classType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

