/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.LinkCallbackMetadata;
import com.plaid.client.model.PlaidError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Webhook containing metadata proxied over from Link callback e.g `onEvent`, `onExit`, `onSuccess`.")
public class LinkDeliveryCallbackWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_LINK_DELIVERY_SESSION_ID = "link_delivery_session_id";
    @SerializedName(value="link_delivery_session_id")
    private String linkDeliverySessionId;
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private String timestamp;
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private PlaidError error;
    public static final String SERIALIZED_NAME_LINK_CALLBACK_METADATA = "link_callback_metadata";
    @SerializedName(value="link_callback_metadata")
    private LinkCallbackMetadata linkCallbackMetadata;

    public LinkDeliveryCallbackWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`LINK_DELIVERY`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public LinkDeliveryCallbackWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`LINK_CALLBACK`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public LinkDeliveryCallbackWebhook linkDeliverySessionId(String linkDeliverySessionId) {
        this.linkDeliverySessionId = linkDeliverySessionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the Hosted Link session.")
    public String getLinkDeliverySessionId() {
        return this.linkDeliverySessionId;
    }

    public void setLinkDeliverySessionId(String linkDeliverySessionId) {
        this.linkDeliverySessionId = linkDeliverySessionId;
    }

    public LinkDeliveryCallbackWebhook timestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(required=true, value="Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format.")
    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public LinkDeliveryCallbackWebhook error(PlaidError error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PlaidError getError() {
        return this.error;
    }

    public void setError(PlaidError error) {
        this.error = error;
    }

    public LinkDeliveryCallbackWebhook linkCallbackMetadata(LinkCallbackMetadata linkCallbackMetadata) {
        this.linkCallbackMetadata = linkCallbackMetadata;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public LinkCallbackMetadata getLinkCallbackMetadata() {
        return this.linkCallbackMetadata;
    }

    public void setLinkCallbackMetadata(LinkCallbackMetadata linkCallbackMetadata) {
        this.linkCallbackMetadata = linkCallbackMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkDeliveryCallbackWebhook linkDeliveryCallbackWebhook = (LinkDeliveryCallbackWebhook)o;
        return Objects.equals(this.webhookType, linkDeliveryCallbackWebhook.webhookType) && Objects.equals(this.webhookCode, linkDeliveryCallbackWebhook.webhookCode) && Objects.equals(this.linkDeliverySessionId, linkDeliveryCallbackWebhook.linkDeliverySessionId) && Objects.equals(this.timestamp, linkDeliveryCallbackWebhook.timestamp) && Objects.equals(this.error, linkDeliveryCallbackWebhook.error) && Objects.equals(this.linkCallbackMetadata, linkDeliveryCallbackWebhook.linkCallbackMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.webhookType, this.webhookCode, this.linkDeliverySessionId, this.timestamp, this.error, this.linkCallbackMetadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkDeliveryCallbackWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    linkDeliverySessionId: ").append(this.toIndentedString(this.linkDeliverySessionId)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    linkCallbackMetadata: ").append(this.toIndentedString(this.linkCallbackMetadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

