/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="LinkDeliveryCreateResponse defines the response schema for `/link_delivery/create`")
public class LinkDeliveryCreateResponse {
    public static final String SERIALIZED_NAME_LINK_DELIVERY_URL = "link_delivery_url";
    @SerializedName(value="link_delivery_url")
    private String linkDeliveryUrl;
    public static final String SERIALIZED_NAME_LINK_DELIVERY_SESSION_ID = "link_delivery_session_id";
    @SerializedName(value="link_delivery_session_id")
    private String linkDeliverySessionId;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public LinkDeliveryCreateResponse linkDeliveryUrl(String linkDeliveryUrl) {
        this.linkDeliveryUrl = linkDeliveryUrl;
        return this;
    }

    @ApiModelProperty(required=true, value="The URL to the Hosted Link session, which will be delivered by the specified delivery method.")
    public String getLinkDeliveryUrl() {
        return this.linkDeliveryUrl;
    }

    public void setLinkDeliveryUrl(String linkDeliveryUrl) {
        this.linkDeliveryUrl = linkDeliveryUrl;
    }

    public LinkDeliveryCreateResponse linkDeliverySessionId(String linkDeliverySessionId) {
        this.linkDeliverySessionId = linkDeliverySessionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID for the Hosted Link session. Same as the `link_token` string excluding the \"link-{env}-\" prefix.")
    public String getLinkDeliverySessionId() {
        return this.linkDeliverySessionId;
    }

    public void setLinkDeliverySessionId(String linkDeliverySessionId) {
        this.linkDeliverySessionId = linkDeliverySessionId;
    }

    public LinkDeliveryCreateResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkDeliveryCreateResponse linkDeliveryCreateResponse = (LinkDeliveryCreateResponse)o;
        return Objects.equals(this.linkDeliveryUrl, linkDeliveryCreateResponse.linkDeliveryUrl) && Objects.equals(this.linkDeliverySessionId, linkDeliveryCreateResponse.linkDeliverySessionId) && Objects.equals(this.requestId, linkDeliveryCreateResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.linkDeliveryUrl, this.linkDeliverySessionId, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkDeliveryCreateResponse {\n");
        sb.append("    linkDeliveryUrl: ").append(this.toIndentedString(this.linkDeliveryUrl)).append("\n");
        sb.append("    linkDeliverySessionId: ").append(this.toIndentedString(this.linkDeliverySessionId)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

