/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.LinkDeliverySessionStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="LinkDeliveryGetRequest defines the response schema for `/link_delivery/get`")
public class LinkDeliveryGetResponse {
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private LinkDeliverySessionStatus status;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_COMPLETED_AT = "completed_at";
    @SerializedName(value="completed_at")
    private OffsetDateTime completedAt;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;
    public static final String SERIALIZED_NAME_ACCESS_TOKENS = "access_tokens";
    @SerializedName(value="access_tokens")
    private List<String> accessTokens = null;
    public static final String SERIALIZED_NAME_ITEM_IDS = "item_ids";
    @SerializedName(value="item_ids")
    private List<String> itemIds = null;

    public LinkDeliveryGetResponse status(LinkDeliverySessionStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public LinkDeliverySessionStatus getStatus() {
        return this.status;
    }

    public void setStatus(LinkDeliverySessionStatus status) {
        this.status = status;
    }

    public LinkDeliveryGetResponse createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDTHH:mm:ssZ`) indicating the time the given Hosted Link session was created at.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public LinkDeliveryGetResponse completedAt(OffsetDateTime completedAt) {
        this.completedAt = completedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDTHH:mm:ssZ`) indicating the time the given Hosted Link session was completed at.")
    public OffsetDateTime getCompletedAt() {
        return this.completedAt;
    }

    public void setCompletedAt(OffsetDateTime completedAt) {
        this.completedAt = completedAt;
    }

    public LinkDeliveryGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public LinkDeliveryGetResponse accessTokens(List<String> accessTokens) {
        this.accessTokens = accessTokens;
        return this;
    }

    public LinkDeliveryGetResponse addAccessTokensItem(String accessTokensItem) {
        if (this.accessTokens == null) {
            this.accessTokens = new ArrayList<String>();
        }
        this.accessTokens.add(accessTokensItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of access tokens associated with the Hosted Link session.")
    public List<String> getAccessTokens() {
        return this.accessTokens;
    }

    public void setAccessTokens(List<String> accessTokens) {
        this.accessTokens = accessTokens;
    }

    public LinkDeliveryGetResponse itemIds(List<String> itemIds) {
        this.itemIds = itemIds;
        return this;
    }

    public LinkDeliveryGetResponse addItemIdsItem(String itemIdsItem) {
        if (this.itemIds == null) {
            this.itemIds = new ArrayList<String>();
        }
        this.itemIds.add(itemIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of `item_id`s associated with the Hosted Link session.")
    public List<String> getItemIds() {
        return this.itemIds;
    }

    public void setItemIds(List<String> itemIds) {
        this.itemIds = itemIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkDeliveryGetResponse linkDeliveryGetResponse = (LinkDeliveryGetResponse)o;
        return Objects.equals((Object)this.status, (Object)linkDeliveryGetResponse.status) && Objects.equals(this.createdAt, linkDeliveryGetResponse.createdAt) && Objects.equals(this.completedAt, linkDeliveryGetResponse.completedAt) && Objects.equals(this.requestId, linkDeliveryGetResponse.requestId) && Objects.equals(this.accessTokens, linkDeliveryGetResponse.accessTokens) && Objects.equals(this.itemIds, linkDeliveryGetResponse.itemIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.createdAt, this.completedAt, this.requestId, this.accessTokens, this.itemIds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkDeliveryGetResponse {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    completedAt: ").append(this.toIndentedString(this.completedAt)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    accessTokens: ").append(this.toIndentedString(this.accessTokens)).append("\n");
        sb.append("    itemIds: ").append(this.toIndentedString(this.itemIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

