/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.LinkDeliveryCommunicationMethod;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Metadata related to the recipient. If the information required to populate this field is not available, leave it blank.")
public class LinkDeliveryRecipient {
    public static final String SERIALIZED_NAME_COMMUNICATION_METHODS = "communication_methods";
    @SerializedName(value="communication_methods")
    private List<LinkDeliveryCommunicationMethod> communicationMethods = null;
    public static final String SERIALIZED_NAME_FIRST_NAME = "first_name";
    @SerializedName(value="first_name")
    private String firstName;

    public LinkDeliveryRecipient communicationMethods(List<LinkDeliveryCommunicationMethod> communicationMethods) {
        this.communicationMethods = communicationMethods;
        return this;
    }

    public LinkDeliveryRecipient addCommunicationMethodsItem(LinkDeliveryCommunicationMethod communicationMethodsItem) {
        if (this.communicationMethods == null) {
            this.communicationMethods = new ArrayList<LinkDeliveryCommunicationMethod>();
        }
        this.communicationMethods.add(communicationMethodsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list of communication methods to send the Hosted Link session URL to. If delivery is not required, leave this field blank.")
    public List<LinkDeliveryCommunicationMethod> getCommunicationMethods() {
        return this.communicationMethods;
    }

    public void setCommunicationMethods(List<LinkDeliveryCommunicationMethod> communicationMethods) {
        this.communicationMethods = communicationMethods;
    }

    public LinkDeliveryRecipient firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="First name of the recipient. Will be used in the body of the email / text (if configured). If this information is not available, leave this field blank.")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkDeliveryRecipient linkDeliveryRecipient = (LinkDeliveryRecipient)o;
        return Objects.equals(this.communicationMethods, linkDeliveryRecipient.communicationMethods) && Objects.equals(this.firstName, linkDeliveryRecipient.firstName);
    }

    public int hashCode() {
        return Objects.hash(this.communicationMethods, this.firstName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkDeliveryRecipient {\n");
        sb.append("    communicationMethods: ").append(this.toIndentedString(this.communicationMethods)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

