/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.LinkEventMetadata;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An event that occurred while the user was going through Link")
public class LinkEvent {
    public static final String SERIALIZED_NAME_EVENT_NAME = "event_name";
    @SerializedName(value="event_name")
    private String eventName;
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private String timestamp;
    public static final String SERIALIZED_NAME_EVENT_ID = "event_id";
    @SerializedName(value="event_id")
    private String eventId;
    public static final String SERIALIZED_NAME_EVENT_METADATA = "event_metadata";
    @SerializedName(value="event_metadata")
    private LinkEventMetadata eventMetadata;

    public LinkEvent eventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    @ApiModelProperty(required=true, value="Event name")
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public LinkEvent timestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(required=true, value="Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format.")
    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public LinkEvent eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @ApiModelProperty(required=true, value="UUID that can be used to deduplicate events")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public LinkEvent eventMetadata(LinkEventMetadata eventMetadata) {
        this.eventMetadata = eventMetadata;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public LinkEventMetadata getEventMetadata() {
        return this.eventMetadata;
    }

    public void setEventMetadata(LinkEventMetadata eventMetadata) {
        this.eventMetadata = eventMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkEvent linkEvent = (LinkEvent)o;
        return Objects.equals(this.eventName, linkEvent.eventName) && Objects.equals(this.timestamp, linkEvent.timestamp) && Objects.equals(this.eventId, linkEvent.eventId) && Objects.equals(this.eventMetadata, linkEvent.eventMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.eventName, this.timestamp, this.eventId, this.eventMetadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkEvent {\n");
        sb.append("    eventName: ").append(this.toIndentedString(this.eventName)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventMetadata: ").append(this.toIndentedString(this.eventMetadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

