/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Metadata about an event that occurred while the user was going through Link")
public class LinkEventMetadata {
    public static final String SERIALIZED_NAME_ERROR_CODE = "error_code";
    @SerializedName(value="error_code")
    private String errorCode;
    public static final String SERIALIZED_NAME_ERROR_MESSAGE = "error_message";
    @SerializedName(value="error_message")
    private String errorMessage;
    public static final String SERIALIZED_NAME_ERROR_TYPE = "error_type";
    @SerializedName(value="error_type")
    private String errorType;
    public static final String SERIALIZED_NAME_EXIT_STATUS = "exit_status";
    @SerializedName(value="exit_status")
    private String exitStatus;
    public static final String SERIALIZED_NAME_INSTITUTION_ID = "institution_id";
    @SerializedName(value="institution_id")
    private String institutionId;
    public static final String SERIALIZED_NAME_INSTITUTION_NAME = "institution_name";
    @SerializedName(value="institution_name")
    private String institutionName;
    public static final String SERIALIZED_NAME_INSTITUTION_SEARCH_QUERY = "institution_search_query";
    @SerializedName(value="institution_search_query")
    private String institutionSearchQuery;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;
    public static final String SERIALIZED_NAME_MFA_TYPE = "mfa_type";
    @SerializedName(value="mfa_type")
    private String mfaType;
    public static final String SERIALIZED_NAME_VIEW_NAME = "view_name";
    @SerializedName(value="view_name")
    private String viewName;
    public static final String SERIALIZED_NAME_SELECTION = "selection";
    @SerializedName(value="selection")
    private String selection;
    public static final String SERIALIZED_NAME_BRAND_NAME = "brand_name";
    @SerializedName(value="brand_name")
    private String brandName;
    public static final String SERIALIZED_NAME_MATCH_REASON = "match_reason";
    @SerializedName(value="match_reason")
    private String matchReason;
    public static final String SERIALIZED_NAME_ROUTING_NUMBER = "routing_number";
    @SerializedName(value="routing_number")
    private String routingNumber;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER_MASK = "account_number_mask";
    @SerializedName(value="account_number_mask")
    private String accountNumberMask;

    public LinkEventMetadata errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The error code that the user encountered. Emitted by `ERROR`, `EXIT`.")
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public LinkEventMetadata errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The error message that the user encountered. Emitted by: `ERROR`, `EXIT`.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public LinkEventMetadata errorType(String errorType) {
        this.errorType = errorType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The error type that the user encountered. Emitted by: `ERROR`, `EXIT`.")
    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public LinkEventMetadata exitStatus(String exitStatus) {
        this.exitStatus = exitStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The status key indicates the point at which the user exited the Link flow. Emitted by: `EXIT`.")
    public String getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(String exitStatus) {
        this.exitStatus = exitStatus;
    }

    public LinkEventMetadata institutionId(String institutionId) {
        this.institutionId = institutionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the selected institution. Emitted by: all events.")
    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public LinkEventMetadata institutionName(String institutionName) {
        this.institutionName = institutionName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the selected institution. Emitted by: all events.")
    public String getInstitutionName() {
        return this.institutionName;
    }

    public void setInstitutionName(String institutionName) {
        this.institutionName = institutionName;
    }

    public LinkEventMetadata institutionSearchQuery(String institutionSearchQuery) {
        this.institutionSearchQuery = institutionSearchQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The query used to search for institutions. Emitted by: `SEARCH_INSTITUTION`.")
    public String getInstitutionSearchQuery() {
        return this.institutionSearchQuery;
    }

    public void setInstitutionSearchQuery(String institutionSearchQuery) {
        this.institutionSearchQuery = institutionSearchQuery;
    }

    public LinkEventMetadata requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="The request ID for the last request made by Link. This can be shared with Plaid Support to expedite investigation. Emitted by: all events.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public LinkEventMetadata mfaType(String mfaType) {
        this.mfaType = mfaType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set, the user has encountered one of the following MFA types: code, device, questions, selections. Emitted by: `SUBMIT_MFA` and `TRANSITION_VIEW` when view_name is `MFA`.")
    public String getMfaType() {
        return this.mfaType;
    }

    public void setMfaType(String mfaType) {
        this.mfaType = mfaType;
    }

    public LinkEventMetadata viewName(String viewName) {
        this.viewName = viewName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the view that is being transitioned to. Emitted by: `TRANSITION_VIEW`.")
    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public LinkEventMetadata selection(String selection) {
        this.selection = selection;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Either the verification method for a matched institution selected by the user or the Auth Type Select flow type selected by the user. If selection is used to describe selected verification method, then possible values are `phoneotp` or `password`;  if selection is used to describe the selected Auth Type Select flow, then possible values are `flow_type_manual` or `flow_type_instant`. Emitted by: `MATCHED_SELECT_VERIFY_METHOD` and `SELECT_AUTH_TYPE`.")
    public String getSelection() {
        return this.selection;
    }

    public void setSelection(String selection) {
        this.selection = selection;
    }

    public LinkEventMetadata brandName(String brandName) {
        this.brandName = brandName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the selected brand.")
    public String getBrandName() {
        return this.brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public LinkEventMetadata matchReason(String matchReason) {
        this.matchReason = matchReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason this institution was matched, which will be either `returning_user` or `routing_number`. Emitted by: `MATCHED_SELECT_INSTITUTION`.")
    public String getMatchReason() {
        return this.matchReason;
    }

    public void setMatchReason(String matchReason) {
        this.matchReason = matchReason;
    }

    public LinkEventMetadata routingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The routing number submitted by user at the micro-deposits routing number pane. Emitted by `SUBMIT_ROUTING_NUMBER`.")
    public String getRoutingNumber() {
        return this.routingNumber;
    }

    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
    }

    public LinkEventMetadata accountNumberMask(String accountNumberMask) {
        this.accountNumberMask = accountNumberMask;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account number mask extracted from the user-provided account number. If the user-inputted account number is four digits long, `account_number_mask` is empty. Emitted by `SUBMIT_ACCOUNT_NUMBER`.")
    public String getAccountNumberMask() {
        return this.accountNumberMask;
    }

    public void setAccountNumberMask(String accountNumberMask) {
        this.accountNumberMask = accountNumberMask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkEventMetadata linkEventMetadata = (LinkEventMetadata)o;
        return Objects.equals(this.errorCode, linkEventMetadata.errorCode) && Objects.equals(this.errorMessage, linkEventMetadata.errorMessage) && Objects.equals(this.errorType, linkEventMetadata.errorType) && Objects.equals(this.exitStatus, linkEventMetadata.exitStatus) && Objects.equals(this.institutionId, linkEventMetadata.institutionId) && Objects.equals(this.institutionName, linkEventMetadata.institutionName) && Objects.equals(this.institutionSearchQuery, linkEventMetadata.institutionSearchQuery) && Objects.equals(this.requestId, linkEventMetadata.requestId) && Objects.equals(this.mfaType, linkEventMetadata.mfaType) && Objects.equals(this.viewName, linkEventMetadata.viewName) && Objects.equals(this.selection, linkEventMetadata.selection) && Objects.equals(this.brandName, linkEventMetadata.brandName) && Objects.equals(this.matchReason, linkEventMetadata.matchReason) && Objects.equals(this.routingNumber, linkEventMetadata.routingNumber) && Objects.equals(this.accountNumberMask, linkEventMetadata.accountNumberMask);
    }

    public int hashCode() {
        return Objects.hash(this.errorCode, this.errorMessage, this.errorType, this.exitStatus, this.institutionId, this.institutionName, this.institutionSearchQuery, this.requestId, this.mfaType, this.viewName, this.selection, this.brandName, this.matchReason, this.routingNumber, this.accountNumberMask);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkEventMetadata {\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    errorType: ").append(this.toIndentedString(this.errorType)).append("\n");
        sb.append("    exitStatus: ").append(this.toIndentedString(this.exitStatus)).append("\n");
        sb.append("    institutionId: ").append(this.toIndentedString(this.institutionId)).append("\n");
        sb.append("    institutionName: ").append(this.toIndentedString(this.institutionName)).append("\n");
        sb.append("    institutionSearchQuery: ").append(this.toIndentedString(this.institutionSearchQuery)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    mfaType: ").append(this.toIndentedString(this.mfaType)).append("\n");
        sb.append("    viewName: ").append(this.toIndentedString(this.viewName)).append("\n");
        sb.append("    selection: ").append(this.toIndentedString(this.selection)).append("\n");
        sb.append("    brandName: ").append(this.toIndentedString(this.brandName)).append("\n");
        sb.append("    matchReason: ").append(this.toIndentedString(this.matchReason)).append("\n");
        sb.append("    routingNumber: ").append(this.toIndentedString(this.routingNumber)).append("\n");
        sb.append("    accountNumberMask: ").append(this.toIndentedString(this.accountNumberMask)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

