/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.LinkEvent;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="This webhook contains a summary of the events from a Link session and will be fired after the user finishes going through Link. If the user abandons the Link flow (i.e., closes the hosted link webpage or leaves Link open for too long without taking any action), the webhook will be fired 5-15 minutes after the last user interaction. A single Link session may occasionally generate multiple `EVENTS` webhooks. If this occurs, the new webhook will contain all previous events for the session, as well as new events that occurred since the previous `EVENTS` webhook was sent. If this occurs, events can be grouped using the `link_session_id` field and, if necessary, de-duplicated using the `event_id` field. By default, the `EVENTS` webhook is enabled only for clients that are enabled for Hosted Link. If you would like to receive this webhook and are not using Hosted Link, contact your Account Manager.")
public class LinkEventsWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_EVENTS = "events";
    @SerializedName(value="events")
    private List<LinkEvent> events = new ArrayList<LinkEvent>();
    public static final String SERIALIZED_NAME_LINK_SESSION_ID = "link_session_id";
    @SerializedName(value="link_session_id")
    private String linkSessionId;
    public static final String SERIALIZED_NAME_LINK_TOKEN = "link_token";
    @SerializedName(value="link_token")
    private String linkToken;

    public LinkEventsWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`LINK`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public LinkEventsWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`EVENTS`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public LinkEventsWebhook events(List<LinkEvent> events) {
        this.events = events;
        return this;
    }

    public LinkEventsWebhook addEventsItem(LinkEvent eventsItem) {
        this.events.add(eventsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The Link events emitted during the Link session")
    public List<LinkEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<LinkEvent> events) {
        this.events = events;
    }

    public LinkEventsWebhook linkSessionId(String linkSessionId) {
        this.linkSessionId = linkSessionId;
        return this;
    }

    @ApiModelProperty(required=true, value="An identifier for the Link session these events occurred in")
    public String getLinkSessionId() {
        return this.linkSessionId;
    }

    public void setLinkSessionId(String linkSessionId) {
        this.linkSessionId = linkSessionId;
    }

    public LinkEventsWebhook linkToken(String linkToken) {
        this.linkToken = linkToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The Link token used to create the Link session these events are from")
    public String getLinkToken() {
        return this.linkToken;
    }

    public void setLinkToken(String linkToken) {
        this.linkToken = linkToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkEventsWebhook linkEventsWebhook = (LinkEventsWebhook)o;
        return Objects.equals(this.webhookType, linkEventsWebhook.webhookType) && Objects.equals(this.webhookCode, linkEventsWebhook.webhookCode) && Objects.equals(this.events, linkEventsWebhook.events) && Objects.equals(this.linkSessionId, linkEventsWebhook.linkSessionId) && Objects.equals(this.linkToken, linkEventsWebhook.linkToken);
    }

    public int hashCode() {
        return Objects.hash(this.webhookType, this.webhookCode, this.events, this.linkSessionId, this.linkToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkEventsWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    linkSessionId: ").append(this.toIndentedString(this.linkSessionId)).append("\n");
        sb.append("    linkToken: ").append(this.toIndentedString(this.linkToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

