/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="LinkOAuthCorrelationIdExchangeRequest defines the request schema for `/link/oauth/correlation_id/exchange`")
public class LinkOAuthCorrelationIdExchangeRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_LINK_CORRELATION_ID = "link_correlation_id";
    @SerializedName(value="link_correlation_id")
    private String linkCorrelationId;

    public LinkOAuthCorrelationIdExchangeRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public LinkOAuthCorrelationIdExchangeRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public LinkOAuthCorrelationIdExchangeRequest linkCorrelationId(String linkCorrelationId) {
        this.linkCorrelationId = linkCorrelationId;
        return this;
    }

    @ApiModelProperty(required=true, value="A `link_correlation_id` from a received OAuth redirect URI callback")
    public String getLinkCorrelationId() {
        return this.linkCorrelationId;
    }

    public void setLinkCorrelationId(String linkCorrelationId) {
        this.linkCorrelationId = linkCorrelationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkOAuthCorrelationIdExchangeRequest linkOAuthCorrelationIdExchangeRequest = (LinkOAuthCorrelationIdExchangeRequest)o;
        return Objects.equals(this.clientId, linkOAuthCorrelationIdExchangeRequest.clientId) && Objects.equals(this.secret, linkOAuthCorrelationIdExchangeRequest.secret) && Objects.equals(this.linkCorrelationId, linkOAuthCorrelationIdExchangeRequest.linkCorrelationId);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.linkCorrelationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkOAuthCorrelationIdExchangeRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    linkCorrelationId: ").append(this.toIndentedString(this.linkCorrelationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

