/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Contains the state of a completed Link session, along with the public token if available. By default, the `SESSION_FINISHED` webhook is enabled only for clients that are enabled for Hosted Link. If you would like to receive this webhook and are not using Hosted Link, contact your Account Manager.")
public class LinkSessionFinishedWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_LINK_SESSION_ID = "link_session_id";
    @SerializedName(value="link_session_id")
    private String linkSessionId;
    public static final String SERIALIZED_NAME_LINK_TOKEN = "link_token";
    @SerializedName(value="link_token")
    private String linkToken;
    public static final String SERIALIZED_NAME_PUBLIC_TOKEN = "public_token";
    @SerializedName(value="public_token")
    private String publicToken;
    public static final String SERIALIZED_NAME_PUBLIC_TOKENS = "public_tokens";
    @SerializedName(value="public_tokens")
    private List<String> publicTokens = null;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public LinkSessionFinishedWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`LINK`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public LinkSessionFinishedWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`SESSION_FINISHED`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public LinkSessionFinishedWebhook status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The final status of the Link session. Will always be \"SUCCESS\" or \"EXITED\".")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public LinkSessionFinishedWebhook linkSessionId(String linkSessionId) {
        this.linkSessionId = linkSessionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier for the Link session.")
    public String getLinkSessionId() {
        return this.linkSessionId;
    }

    public void setLinkSessionId(String linkSessionId) {
        this.linkSessionId = linkSessionId;
    }

    public LinkSessionFinishedWebhook linkToken(String linkToken) {
        this.linkToken = linkToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The link token used to create the Link session.")
    public String getLinkToken() {
        return this.linkToken;
    }

    public void setLinkToken(String linkToken) {
        this.linkToken = linkToken;
    }

    public LinkSessionFinishedWebhook publicToken(String publicToken) {
        this.publicToken = publicToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The public token generated by the Link session. This field has been deprecated; please use `public_tokens` instead.")
    public String getPublicToken() {
        return this.publicToken;
    }

    public void setPublicToken(String publicToken) {
        this.publicToken = publicToken;
    }

    public LinkSessionFinishedWebhook publicTokens(List<String> publicTokens) {
        this.publicTokens = publicTokens;
        return this;
    }

    public LinkSessionFinishedWebhook addPublicTokensItem(String publicTokensItem) {
        if (this.publicTokens == null) {
            this.publicTokens = new ArrayList<String>();
        }
        this.publicTokens.add(publicTokensItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The public tokens generated by the Link session.")
    public List<String> getPublicTokens() {
        return this.publicTokens;
    }

    public void setPublicTokens(List<String> publicTokens) {
        this.publicTokens = publicTokens;
    }

    public LinkSessionFinishedWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkSessionFinishedWebhook linkSessionFinishedWebhook = (LinkSessionFinishedWebhook)o;
        return Objects.equals(this.webhookType, linkSessionFinishedWebhook.webhookType) && Objects.equals(this.webhookCode, linkSessionFinishedWebhook.webhookCode) && Objects.equals(this.status, linkSessionFinishedWebhook.status) && Objects.equals(this.linkSessionId, linkSessionFinishedWebhook.linkSessionId) && Objects.equals(this.linkToken, linkSessionFinishedWebhook.linkToken) && Objects.equals(this.publicToken, linkSessionFinishedWebhook.publicToken) && Objects.equals(this.publicTokens, linkSessionFinishedWebhook.publicTokens) && Objects.equals((Object)this.environment, (Object)linkSessionFinishedWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.status, this.linkSessionId, this.linkToken, this.publicToken, this.publicTokens, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkSessionFinishedWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    linkSessionId: ").append(this.toIndentedString(this.linkSessionId)).append("\n");
        sb.append("    linkToken: ").append(this.toIndentedString(this.linkToken)).append("\n");
        sb.append("    publicToken: ").append(this.toIndentedString(this.publicToken)).append("\n");
        sb.append("    publicTokens: ").append(this.toIndentedString(this.publicTokens)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

