/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An account attached to the connected Item.")
public class LinkSessionSuccessMetadataAccount {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_MASK = "mask";
    @SerializedName(value="mask")
    private String mask;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_SUBTYPE = "subtype";
    @SerializedName(value="subtype")
    private String subtype;
    public static final String SERIALIZED_NAME_VERIFICATION_STATUS = "verification_status";
    @SerializedName(value="verification_status")
    private String verificationStatus;
    public static final String SERIALIZED_NAME_CLASS_TYPE = "class_type";
    @SerializedName(value="class_type")
    private String classType;

    public LinkSessionSuccessMetadataAccount id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Plaid `account_id` ")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LinkSessionSuccessMetadataAccount name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The official account name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LinkSessionSuccessMetadataAccount mask(String mask) {
        this.mask = mask;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The last 2-4 alphanumeric characters of an account's official account number. Note that the mask may be non-unique between an Item's accounts. It may also not match the mask that the bank displays to the user.")
    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public LinkSessionSuccessMetadataAccount type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account type. See the [Account schema](/docs/api/accounts#account-type-schema) for a full list of possible values")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public LinkSessionSuccessMetadataAccount subtype(String subtype) {
        this.subtype = subtype;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account subtype. See the [Account schema](/docs/api/accounts#account-type-schema) for a full list of possible values")
    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public LinkSessionSuccessMetadataAccount verificationStatus(String verificationStatus) {
        this.verificationStatus = verificationStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates an Item's micro-deposit-based verification or database verification status. Possible values are:  `pending_automatic_verification`: The Item is pending automatic verification  `pending_manual_verification`: The Item is pending manual micro-deposit verification. Items remain in this state until the user successfully verifies the code.  `automatically_verified`: The Item has successfully been automatically verified  `manually_verified`: The Item has successfully been manually verified  `verification_expired`: Plaid was unable to automatically verify the deposit within 7 calendar days and will no longer attempt to validate the Item. Users may retry by submitting their information again through Link.  `verification_failed`: The Item failed manual micro-deposit verification because the user exhausted all 3 verification attempts. Users may retry by submitting their information again through Link.  `database_matched`: The Item has successfully been verified using Plaid's data sources.  `database_insights_pending`: The Database Insights result is pending and will be available upon Auth request. Note: Database Insights is currently a beta feature, please contact your account manager for more information.  `null`: Neither micro-deposit-based verification nor database verification are being used for the Item. ")
    public String getVerificationStatus() {
        return this.verificationStatus;
    }

    public void setVerificationStatus(String verificationStatus) {
        this.verificationStatus = verificationStatus;
    }

    public LinkSessionSuccessMetadataAccount classType(String classType) {
        this.classType = classType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If micro-deposit verification is being used, indicates whether the account being verified is a `business` or `personal` account.")
    public String getClassType() {
        return this.classType;
    }

    public void setClassType(String classType) {
        this.classType = classType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkSessionSuccessMetadataAccount linkSessionSuccessMetadataAccount = (LinkSessionSuccessMetadataAccount)o;
        return Objects.equals(this.id, linkSessionSuccessMetadataAccount.id) && Objects.equals(this.name, linkSessionSuccessMetadataAccount.name) && Objects.equals(this.mask, linkSessionSuccessMetadataAccount.mask) && Objects.equals(this.type, linkSessionSuccessMetadataAccount.type) && Objects.equals(this.subtype, linkSessionSuccessMetadataAccount.subtype) && Objects.equals(this.verificationStatus, linkSessionSuccessMetadataAccount.verificationStatus) && Objects.equals(this.classType, linkSessionSuccessMetadataAccount.classType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.mask, this.type, this.subtype, this.verificationStatus, this.classType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkSessionSuccessMetadataAccount {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    mask: ").append(this.toIndentedString(this.mask)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    subtype: ").append(this.toIndentedString(this.subtype)).append("\n");
        sb.append("    verificationStatus: ").append(this.toIndentedString(this.verificationStatus)).append("\n");
        sb.append("    classType: ").append(this.toIndentedString(this.classType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

