/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CreditFilter;
import com.plaid.client.model.DepositoryFilter;
import com.plaid.client.model.InvestmentFilter;
import com.plaid.client.model.LoanFilter;
import com.plaid.client.model.OtherFilter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="By default, Link will provide limited account filtering: it will only display Institutions that are compatible with all products supplied in the `products` parameter of `/link/token/create`, and, if `auth` is specified in the `products` array, will also filter out accounts other than `checking` and `savings` accounts on the Account Select pane. You can further limit the accounts shown in Link by using `account_filters` to specify the account subtypes to be shown in Link. Only the specified subtypes will be shown. This filtering applies to both the Account Select view (if enabled) and the Institution Select view. Institutions that do not support the selected subtypes will be omitted from Link. To indicate that all subtypes should be shown, use the value `\"all\"`. If the `account_filters` filter is used, any account type for which a filter is not specified will be entirely omitted from Link. For a full list of valid types and subtypes, see the [Account schema](https://plaid.com/docs/api/accounts#account-type-schema).  The filter may or may not impact the list of accounts shown by the institution in the OAuth account selection flow, depending on the specific institution. If the user selects excluded account subtypes in the OAuth flow, these accounts will not be added to the Item. If the user selects only excluded account subtypes, the link attempt will fail and the user will be prompted to try again. ")
public class LinkTokenAccountFilters {
    public static final String SERIALIZED_NAME_DEPOSITORY = "depository";
    @SerializedName(value="depository")
    private DepositoryFilter depository;
    public static final String SERIALIZED_NAME_CREDIT = "credit";
    @SerializedName(value="credit")
    private CreditFilter credit;
    public static final String SERIALIZED_NAME_LOAN = "loan";
    @SerializedName(value="loan")
    private LoanFilter loan;
    public static final String SERIALIZED_NAME_INVESTMENT = "investment";
    @SerializedName(value="investment")
    private InvestmentFilter investment;
    public static final String SERIALIZED_NAME_OTHER = "other";
    @SerializedName(value="other")
    private OtherFilter other;

    public LinkTokenAccountFilters depository(DepositoryFilter depository) {
        this.depository = depository;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public DepositoryFilter getDepository() {
        return this.depository;
    }

    public void setDepository(DepositoryFilter depository) {
        this.depository = depository;
    }

    public LinkTokenAccountFilters credit(CreditFilter credit) {
        this.credit = credit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CreditFilter getCredit() {
        return this.credit;
    }

    public void setCredit(CreditFilter credit) {
        this.credit = credit;
    }

    public LinkTokenAccountFilters loan(LoanFilter loan) {
        this.loan = loan;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LoanFilter getLoan() {
        return this.loan;
    }

    public void setLoan(LoanFilter loan) {
        this.loan = loan;
    }

    public LinkTokenAccountFilters investment(InvestmentFilter investment) {
        this.investment = investment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public InvestmentFilter getInvestment() {
        return this.investment;
    }

    public void setInvestment(InvestmentFilter investment) {
        this.investment = investment;
    }

    public LinkTokenAccountFilters other(OtherFilter other) {
        this.other = other;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OtherFilter getOther() {
        return this.other;
    }

    public void setOther(OtherFilter other) {
        this.other = other;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkTokenAccountFilters linkTokenAccountFilters = (LinkTokenAccountFilters)o;
        return Objects.equals(this.depository, linkTokenAccountFilters.depository) && Objects.equals(this.credit, linkTokenAccountFilters.credit) && Objects.equals(this.loan, linkTokenAccountFilters.loan) && Objects.equals(this.investment, linkTokenAccountFilters.investment) && Objects.equals(this.other, linkTokenAccountFilters.other);
    }

    public int hashCode() {
        return Objects.hash(this.depository, this.credit, this.loan, this.investment, this.other);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkTokenAccountFilters {\n");
        sb.append("    depository: ").append(this.toIndentedString(this.depository)).append("\n");
        sb.append("    credit: ").append(this.toIndentedString(this.credit)).append("\n");
        sb.append("    loan: ").append(this.toIndentedString(this.loan)).append("\n");
        sb.append("    investment: ").append(this.toIndentedString(this.investment)).append("\n");
        sb.append("    other: ").append(this.toIndentedString(this.other)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

