/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.HostedLinkDeliveryMethod;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Configuration parameters for Hosted Link. To request access to Hosted Link, contact your account manager.")
public class LinkTokenCreateHostedLink {
    public static final String SERIALIZED_NAME_DELIVERY_METHOD = "delivery_method";
    @SerializedName(value="delivery_method")
    private HostedLinkDeliveryMethod deliveryMethod;
    public static final String SERIALIZED_NAME_COMPLETION_REDIRECT_URI = "completion_redirect_uri";
    @SerializedName(value="completion_redirect_uri")
    private String completionRedirectUri;
    public static final String SERIALIZED_NAME_URL_LIFETIME_SECONDS = "url_lifetime_seconds";
    @SerializedName(value="url_lifetime_seconds")
    private Integer urlLifetimeSeconds;
    public static final String SERIALIZED_NAME_IS_MOBILE_APP = "is_mobile_app";
    @SerializedName(value="is_mobile_app")
    private Boolean isMobileApp = false;

    public LinkTokenCreateHostedLink deliveryMethod(HostedLinkDeliveryMethod deliveryMethod) {
        this.deliveryMethod = deliveryMethod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public HostedLinkDeliveryMethod getDeliveryMethod() {
        return this.deliveryMethod;
    }

    public void setDeliveryMethod(HostedLinkDeliveryMethod deliveryMethod) {
        this.deliveryMethod = deliveryMethod;
    }

    public LinkTokenCreateHostedLink completionRedirectUri(String completionRedirectUri) {
        this.completionRedirectUri = completionRedirectUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URI that Hosted Link will redirect to upon completion of the Link flow. This will only occur in Hosted Link sessions, not in other implementation methods. ")
    public String getCompletionRedirectUri() {
        return this.completionRedirectUri;
    }

    public void setCompletionRedirectUri(String completionRedirectUri) {
        this.completionRedirectUri = completionRedirectUri;
    }

    public LinkTokenCreateHostedLink urlLifetimeSeconds(Integer urlLifetimeSeconds) {
        this.urlLifetimeSeconds = urlLifetimeSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="How many seconds the link will be valid for. Must be positive. Cannot be longer than 21 days. The default lifetime is 4 hours. ")
    public Integer getUrlLifetimeSeconds() {
        return this.urlLifetimeSeconds;
    }

    public void setUrlLifetimeSeconds(Integer urlLifetimeSeconds) {
        this.urlLifetimeSeconds = urlLifetimeSeconds;
    }

    public LinkTokenCreateHostedLink isMobileApp(Boolean isMobileApp) {
        this.isMobileApp = isMobileApp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This indicates whether the client is opening hosted Link in a mobile app in an out of process web view (OOPWV) (i.e., an `AsWebAuthenticationSession` / `SFSafariViewController` or Android Custom Tab). ")
    public Boolean getIsMobileApp() {
        return this.isMobileApp;
    }

    public void setIsMobileApp(Boolean isMobileApp) {
        this.isMobileApp = isMobileApp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkTokenCreateHostedLink linkTokenCreateHostedLink = (LinkTokenCreateHostedLink)o;
        return Objects.equals((Object)this.deliveryMethod, (Object)linkTokenCreateHostedLink.deliveryMethod) && Objects.equals(this.completionRedirectUri, linkTokenCreateHostedLink.completionRedirectUri) && Objects.equals(this.urlLifetimeSeconds, linkTokenCreateHostedLink.urlLifetimeSeconds) && Objects.equals(this.isMobileApp, linkTokenCreateHostedLink.isMobileApp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deliveryMethod, this.completionRedirectUri, this.urlLifetimeSeconds, this.isMobileApp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkTokenCreateHostedLink {\n");
        sb.append("    deliveryMethod: ").append(this.toIndentedString((Object)this.deliveryMethod)).append("\n");
        sb.append("    completionRedirectUri: ").append(this.toIndentedString(this.completionRedirectUri)).append("\n");
        sb.append("    urlLifetimeSeconds: ").append(this.toIndentedString(this.urlLifetimeSeconds)).append("\n");
        sb.append("    isMobileApp: ").append(this.toIndentedString(this.isMobileApp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

