/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IncomeVerificationDocParsingConfig;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Identity object used to specify document upload")
public class LinkTokenCreateIdentity {
    public static final String SERIALIZED_NAME_IS_DOCUMENT_UPLOAD = "is_document_upload";
    @SerializedName(value="is_document_upload")
    private Boolean isDocumentUpload;
    public static final String SERIALIZED_NAME_ACCOUNT_IDS = "account_ids";
    @SerializedName(value="account_ids")
    private List<String> accountIds = null;
    public static final String SERIALIZED_NAME_PARSING_CONFIGS = "parsing_configs";
    @SerializedName(value="parsing_configs")
    private List<IncomeVerificationDocParsingConfig> parsingConfigs = null;

    public LinkTokenCreateIdentity isDocumentUpload(Boolean isDocumentUpload) {
        this.isDocumentUpload = isDocumentUpload;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used to specify whether the Link session is Identity Document Upload")
    public Boolean getIsDocumentUpload() {
        return this.isDocumentUpload;
    }

    public void setIsDocumentUpload(Boolean isDocumentUpload) {
        this.isDocumentUpload = isDocumentUpload;
    }

    public LinkTokenCreateIdentity accountIds(List<String> accountIds) {
        this.accountIds = accountIds;
        return this;
    }

    public LinkTokenCreateIdentity addAccountIdsItem(String accountIdsItem) {
        if (this.accountIds == null) {
            this.accountIds = new ArrayList<String>();
        }
        this.accountIds.add(accountIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of `account_ids`")
    public List<String> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(List<String> accountIds) {
        this.accountIds = accountIds;
    }

    public LinkTokenCreateIdentity parsingConfigs(List<IncomeVerificationDocParsingConfig> parsingConfigs) {
        this.parsingConfigs = parsingConfigs;
        return this;
    }

    public LinkTokenCreateIdentity addParsingConfigsItem(IncomeVerificationDocParsingConfig parsingConfigsItem) {
        if (this.parsingConfigs == null) {
            this.parsingConfigs = new ArrayList<IncomeVerificationDocParsingConfig>();
        }
        this.parsingConfigs.add(parsingConfigsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of parsing configurations. Valid parsing configurations are `ocr` and `risk_signals`. If parsing configurations are omitted, defaults to `ocr`")
    public List<IncomeVerificationDocParsingConfig> getParsingConfigs() {
        return this.parsingConfigs;
    }

    public void setParsingConfigs(List<IncomeVerificationDocParsingConfig> parsingConfigs) {
        this.parsingConfigs = parsingConfigs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkTokenCreateIdentity linkTokenCreateIdentity = (LinkTokenCreateIdentity)o;
        return Objects.equals(this.isDocumentUpload, linkTokenCreateIdentity.isDocumentUpload) && Objects.equals(this.accountIds, linkTokenCreateIdentity.accountIds) && Objects.equals(this.parsingConfigs, linkTokenCreateIdentity.parsingConfigs);
    }

    public int hashCode() {
        return Objects.hash(this.isDocumentUpload, this.accountIds, this.parsingConfigs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkTokenCreateIdentity {\n");
        sb.append("    isDocumentUpload: ").append(this.toIndentedString(this.isDocumentUpload)).append("\n");
        sb.append("    accountIds: ").append(this.toIndentedString(this.accountIds)).append("\n");
        sb.append("    parsingConfigs: ").append(this.toIndentedString(this.parsingConfigs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

