/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ConsumerReportPermissiblePurpose;
import com.plaid.client.model.CountryCode;
import com.plaid.client.model.LinkTokenAccountFilters;
import com.plaid.client.model.LinkTokenCreateCardSwitch;
import com.plaid.client.model.LinkTokenCreateHostedLink;
import com.plaid.client.model.LinkTokenCreateIdentity;
import com.plaid.client.model.LinkTokenCreateInstitutionData;
import com.plaid.client.model.LinkTokenCreateRequestAuth;
import com.plaid.client.model.LinkTokenCreateRequestBaseReport;
import com.plaid.client.model.LinkTokenCreateRequestCraOptions;
import com.plaid.client.model.LinkTokenCreateRequestCreditPartnerInsights;
import com.plaid.client.model.LinkTokenCreateRequestDepositSwitch;
import com.plaid.client.model.LinkTokenCreateRequestEmployment;
import com.plaid.client.model.LinkTokenCreateRequestIdentityVerification;
import com.plaid.client.model.LinkTokenCreateRequestIncomeVerification;
import com.plaid.client.model.LinkTokenCreateRequestPaymentInitiation;
import com.plaid.client.model.LinkTokenCreateRequestStatements;
import com.plaid.client.model.LinkTokenCreateRequestTransfer;
import com.plaid.client.model.LinkTokenCreateRequestUpdate;
import com.plaid.client.model.LinkTokenCreateRequestUser;
import com.plaid.client.model.LinkTokenEUConfig;
import com.plaid.client.model.LinkTokenInvestments;
import com.plaid.client.model.LinkTokenInvestmentsAuth;
import com.plaid.client.model.LinkTokenTransactions;
import com.plaid.client.model.Products;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="LinkTokenCreateRequest defines the request schema for `/link/token/create`")
public class LinkTokenCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_CLIENT_NAME = "client_name";
    @SerializedName(value="client_name")
    private String clientName;
    public static final String SERIALIZED_NAME_LANGUAGE = "language";
    @SerializedName(value="language")
    private String language;
    public static final String SERIALIZED_NAME_COUNTRY_CODES = "country_codes";
    @SerializedName(value="country_codes")
    private List<CountryCode> countryCodes = new ArrayList<CountryCode>();
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private LinkTokenCreateRequestUser user;
    public static final String SERIALIZED_NAME_PRODUCTS = "products";
    @SerializedName(value="products")
    private List<Products> products = null;
    public static final String SERIALIZED_NAME_REQUIRED_IF_SUPPORTED_PRODUCTS = "required_if_supported_products";
    @SerializedName(value="required_if_supported_products")
    private List<Products> requiredIfSupportedProducts = null;
    public static final String SERIALIZED_NAME_OPTIONAL_PRODUCTS = "optional_products";
    @SerializedName(value="optional_products")
    private List<Products> optionalProducts = null;
    public static final String SERIALIZED_NAME_ADDITIONAL_CONSENTED_PRODUCTS = "additional_consented_products";
    @SerializedName(value="additional_consented_products")
    private List<Products> additionalConsentedProducts = null;
    public static final String SERIALIZED_NAME_WEBHOOK = "webhook";
    @SerializedName(value="webhook")
    private String webhook;
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_ACCESS_TOKENS = "access_tokens";
    @SerializedName(value="access_tokens")
    private List<String> accessTokens = null;
    public static final String SERIALIZED_NAME_LINK_CUSTOMIZATION_NAME = "link_customization_name";
    @SerializedName(value="link_customization_name")
    private String linkCustomizationName;
    public static final String SERIALIZED_NAME_REDIRECT_URI = "redirect_uri";
    @SerializedName(value="redirect_uri")
    private String redirectUri;
    public static final String SERIALIZED_NAME_ANDROID_PACKAGE_NAME = "android_package_name";
    @SerializedName(value="android_package_name")
    private String androidPackageName;
    public static final String SERIALIZED_NAME_INSTITUTION_DATA = "institution_data";
    @SerializedName(value="institution_data")
    private LinkTokenCreateInstitutionData institutionData;
    public static final String SERIALIZED_NAME_CARD_SWITCH = "card_switch";
    @SerializedName(value="card_switch")
    private LinkTokenCreateCardSwitch cardSwitch;
    public static final String SERIALIZED_NAME_ACCOUNT_FILTERS = "account_filters";
    @SerializedName(value="account_filters")
    private LinkTokenAccountFilters accountFilters;
    public static final String SERIALIZED_NAME_EU_CONFIG = "eu_config";
    @SerializedName(value="eu_config")
    private LinkTokenEUConfig euConfig;
    public static final String SERIALIZED_NAME_INSTITUTION_ID = "institution_id";
    @SerializedName(value="institution_id")
    private String institutionId;
    public static final String SERIALIZED_NAME_PAYMENT_INITIATION = "payment_initiation";
    @SerializedName(value="payment_initiation")
    private LinkTokenCreateRequestPaymentInitiation paymentInitiation;
    public static final String SERIALIZED_NAME_DEPOSIT_SWITCH = "deposit_switch";
    @SerializedName(value="deposit_switch")
    private LinkTokenCreateRequestDepositSwitch depositSwitch;
    public static final String SERIALIZED_NAME_EMPLOYMENT = "employment";
    @SerializedName(value="employment")
    private LinkTokenCreateRequestEmployment employment;
    public static final String SERIALIZED_NAME_INCOME_VERIFICATION = "income_verification";
    @SerializedName(value="income_verification")
    private LinkTokenCreateRequestIncomeVerification incomeVerification;
    public static final String SERIALIZED_NAME_BASE_REPORT = "base_report";
    @SerializedName(value="base_report")
    private LinkTokenCreateRequestBaseReport baseReport;
    public static final String SERIALIZED_NAME_CREDIT_PARTNER_INSIGHTS = "credit_partner_insights";
    @SerializedName(value="credit_partner_insights")
    private LinkTokenCreateRequestCreditPartnerInsights creditPartnerInsights;
    public static final String SERIALIZED_NAME_CRA_OPTIONS = "cra_options";
    @SerializedName(value="cra_options")
    private LinkTokenCreateRequestCraOptions craOptions;
    public static final String SERIALIZED_NAME_CONSUMER_REPORT_PERMISSIBLE_PURPOSE = "consumer_report_permissible_purpose";
    @SerializedName(value="consumer_report_permissible_purpose")
    private ConsumerReportPermissiblePurpose consumerReportPermissiblePurpose;
    public static final String SERIALIZED_NAME_AUTH = "auth";
    @SerializedName(value="auth")
    private LinkTokenCreateRequestAuth auth;
    public static final String SERIALIZED_NAME_TRANSFER = "transfer";
    @SerializedName(value="transfer")
    private LinkTokenCreateRequestTransfer transfer;
    public static final String SERIALIZED_NAME_UPDATE = "update";
    @SerializedName(value="update")
    private LinkTokenCreateRequestUpdate update;
    public static final String SERIALIZED_NAME_IDENTITY_VERIFICATION = "identity_verification";
    @SerializedName(value="identity_verification")
    private LinkTokenCreateRequestIdentityVerification identityVerification;
    public static final String SERIALIZED_NAME_STATEMENTS = "statements";
    @SerializedName(value="statements")
    private LinkTokenCreateRequestStatements statements;
    public static final String SERIALIZED_NAME_USER_TOKEN = "user_token";
    @SerializedName(value="user_token")
    private String userToken;
    public static final String SERIALIZED_NAME_INVESTMENTS = "investments";
    @SerializedName(value="investments")
    private LinkTokenInvestments investments;
    public static final String SERIALIZED_NAME_INVESTMENTS_AUTH = "investments_auth";
    @SerializedName(value="investments_auth")
    private LinkTokenInvestmentsAuth investmentsAuth;
    public static final String SERIALIZED_NAME_HOSTED_LINK = "hosted_link";
    @SerializedName(value="hosted_link")
    private LinkTokenCreateHostedLink hostedLink;
    public static final String SERIALIZED_NAME_TRANSACTIONS = "transactions";
    @SerializedName(value="transactions")
    private LinkTokenTransactions transactions;
    public static final String SERIALIZED_NAME_CRA_ENABLED = "cra_enabled";
    @SerializedName(value="cra_enabled")
    private Boolean craEnabled;
    public static final String SERIALIZED_NAME_IDENTITY = "identity";
    @SerializedName(value="identity")
    private LinkTokenCreateIdentity identity;
    public static final String SERIALIZED_NAME_FINANCEKIT_SUPPORTED = "financekit_supported";
    @SerializedName(value="financekit_supported")
    private Boolean financekitSupported;
    public static final String SERIALIZED_NAME_ENABLE_MULTI_ITEM_LINK = "enable_multi_item_link";
    @SerializedName(value="enable_multi_item_link")
    private Boolean enableMultiItemLink;

    public LinkTokenCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public LinkTokenCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public LinkTokenCreateRequest clientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of your application, as it should be displayed in Link. Maximum length of 30 characters. If a value longer than 30 characters is provided, Link will display \"This Application\" instead.")
    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public LinkTokenCreateRequest language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(required=true, value="The language that Link should be displayed in. When initializing with Identity Verification, this field is not used; for more details, see [Identity Verification supported languages](https://www.plaid.com/docs/identity-verification/#supported-languages).  Supported languages are: - Danish (`'da'`) - Dutch (`'nl'`) - English (`'en'`) - Estonian (`'et'`) - French (`'fr'`) - German (`'de'`) - Italian (`'it'`) - Latvian (`'lv'`) - Lithuanian (`'lt'`) - Norwegian (`'no'`) - Polish (`'pl'`) - Portuguese (`'pt'`) - Romanian (`'ro'`) - Spanish (`'es'`) - Swedish (`'sv'`)  When using a Link customization, the language configured here must match the setting in the customization, or the customization will not be applied.")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public LinkTokenCreateRequest countryCodes(List<CountryCode> countryCodes) {
        this.countryCodes = countryCodes;
        return this;
    }

    public LinkTokenCreateRequest addCountryCodesItem(CountryCode countryCodesItem) {
        this.countryCodes.add(countryCodesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Specify an array of Plaid-supported country codes using the ISO-3166-1 alpha-2 country code standard. Institutions from all listed countries will be shown. For a complete mapping of supported products by country, see https://plaid.com/global/.  If using Identity Verification, `country_codes` should be set to the country where your company is based, not the country where your user is located. For all other products, `country_codes` represents the location of your user's financial institution.  If Link is launched with multiple country codes, only products that you are enabled for in all countries will be used by Link. Note that while all countries are enabled by default in Sandbox, in Production only US and Canada are enabled by default. To request access to European institutions, [file a product access Support ticket](https://dashboard.plaid.com/support/new/product-and-development/product-troubleshooting/request-product-access) via the Plaid dashboard.  If using a Link customization, make sure the country codes in the customization match those specified in `country_codes`, or the customization may not be applied.  If using the Auth features Instant Match, Instant Micro-deposits, Same-day Micro-deposits, Automated Micro-deposits, or Database Insights, `country_codes` must be set to `['US']`.")
    public List<CountryCode> getCountryCodes() {
        return this.countryCodes;
    }

    public void setCountryCodes(List<CountryCode> countryCodes) {
        this.countryCodes = countryCodes;
    }

    public LinkTokenCreateRequest user(LinkTokenCreateRequestUser user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public LinkTokenCreateRequestUser getUser() {
        return this.user;
    }

    public void setUser(LinkTokenCreateRequestUser user) {
        this.user = user;
    }

    public LinkTokenCreateRequest products(List<Products> products) {
        this.products = products;
        return this;
    }

    public LinkTokenCreateRequest addProductsItem(Products productsItem) {
        if (this.products == null) {
            this.products = new ArrayList<Products>();
        }
        this.products.add(productsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of Plaid product(s) you wish to use. If launching Link in update mode, should be omitted (unless you are using update mode to add Income or Assets to an Item); required otherwise.  `balance` is *not* a valid value, the Balance product does not require explicit initialization and will automatically be initialized when any other product is initialized.  The products specified here will determine which institutions will be available to your users in Link. Only institutions that support *all* requested products can be selected; a if a user attempts to select an institution that does not support a listed product, a \"Connectivity not supported\" error message will appear in Link. To maximize the number of institutions available, initialize Link with the minimal product set required for your use case. Additional products can be included via the [`optional_products`](https://plaid.com/docs/api/tokens/#link-token-create-request-optional-products) or  [`required_if_supported_products`](https://plaid.com/docs/api/tokens/#link-token-create-request-required-if-supported-products) fields, or can be initialized by calling the endpoint after obtaining an access token. For details and exceptions, see [Choosing when to initialize products](https://plaid.com/docs/link/initializing-products/).  Note that, unless you have opted to disable Instant Match support, institutions that support Instant Match will also be shown in Link if `auth` is specified as a product, even though these institutions do not contain `auth` in their product array.  In Production, you will be billed for each product that you specify when initializing Link. Note that a product cannot be removed from an Item once the Item has been initialized with that product. To stop billing on an Item for subscription-based products, such as Liabilities, Investments, and Transactions, remove the Item via `/item/remove`.")
    public List<Products> getProducts() {
        return this.products;
    }

    public void setProducts(List<Products> products) {
        this.products = products;
    }

    public LinkTokenCreateRequest requiredIfSupportedProducts(List<Products> requiredIfSupportedProducts) {
        this.requiredIfSupportedProducts = requiredIfSupportedProducts;
        return this;
    }

    public LinkTokenCreateRequest addRequiredIfSupportedProductsItem(Products requiredIfSupportedProductsItem) {
        if (this.requiredIfSupportedProducts == null) {
            this.requiredIfSupportedProducts = new ArrayList<Products>();
        }
        this.requiredIfSupportedProducts.add(requiredIfSupportedProductsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of Plaid product(s) you wish to use only if the institution and account(s) selected by the user support the product. Institutions that do not support these products will still be shown in Link. The products will only be extracted and billed if the user selects an institution and account type that supports them.  There should be no overlap between this array and the `products`, `optional_products`, or `additional_consented_products` arrays. The `products` array must have at least one product.  For more details on using this feature, see [Required if Supported Products](https://www.plaid.com/docs/link/initializing-products/#required-if-supported-products).")
    public List<Products> getRequiredIfSupportedProducts() {
        return this.requiredIfSupportedProducts;
    }

    public void setRequiredIfSupportedProducts(List<Products> requiredIfSupportedProducts) {
        this.requiredIfSupportedProducts = requiredIfSupportedProducts;
    }

    public LinkTokenCreateRequest optionalProducts(List<Products> optionalProducts) {
        this.optionalProducts = optionalProducts;
        return this;
    }

    public LinkTokenCreateRequest addOptionalProductsItem(Products optionalProductsItem) {
        if (this.optionalProducts == null) {
            this.optionalProducts = new ArrayList<Products>();
        }
        this.optionalProducts.add(optionalProductsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of Plaid product(s) that will enhance the consumer's use case, but that your app can function without. Plaid will attempt to fetch data for these products on a best-effort basis, and failure to support these products will not affect Item creation.  There should be no overlap between this array and the `products`, `required_if_supported_products`, or `additional_consented_products` arrays. The `products` array must have at least one product.  For more details on using this feature, see [Optional Products](https://www.plaid.com/docs/link/initializing-products/#optional-products).")
    public List<Products> getOptionalProducts() {
        return this.optionalProducts;
    }

    public void setOptionalProducts(List<Products> optionalProducts) {
        this.optionalProducts = optionalProducts;
    }

    public LinkTokenCreateRequest additionalConsentedProducts(List<Products> additionalConsentedProducts) {
        this.additionalConsentedProducts = additionalConsentedProducts;
        return this;
    }

    public LinkTokenCreateRequest addAdditionalConsentedProductsItem(Products additionalConsentedProductsItem) {
        if (this.additionalConsentedProducts == null) {
            this.additionalConsentedProducts = new ArrayList<Products>();
        }
        this.additionalConsentedProducts.add(additionalConsentedProductsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of additional Plaid product(s) you wish to collect consent for to support your use case. These products will not be billed until you start using them by calling the relevant endpoints.  `balance` is *not* a valid value, the Balance product does not require explicit initialization and will automatically have consent collected.  Institutions that do not support these products will still be shown in Link.  There should be no overlap between this array and the `products` or `required_if_supported_products` arrays.")
    public List<Products> getAdditionalConsentedProducts() {
        return this.additionalConsentedProducts;
    }

    public void setAdditionalConsentedProducts(List<Products> additionalConsentedProducts) {
        this.additionalConsentedProducts = additionalConsentedProducts;
    }

    public LinkTokenCreateRequest webhook(String webhook) {
        this.webhook = webhook;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The destination URL to which any webhooks should be sent. Note that webhooks for Payment Initiation (e-wallet transactions only), Transfer, Bank Transfer (including Auth micro-deposit notification webhooks) and Identity Verification are configured via the Dashboard instead.")
    public String getWebhook() {
        return this.webhook;
    }

    public void setWebhook(String webhook) {
        this.webhook = webhook;
    }

    public LinkTokenCreateRequest accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `access_token` associated with the Item to update or reference, used when updating, modifying, or accessing an existing `access_token`. Used when launching Link in update mode, when completing the Same-day (manual) Micro-deposit flow, or (optionally) when initializing Link for a returning user as part of the Transfer UI flow.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public LinkTokenCreateRequest accessTokens(List<String> accessTokens) {
        this.accessTokens = accessTokens;
        return this;
    }

    public LinkTokenCreateRequest addAccessTokensItem(String accessTokensItem) {
        if (this.accessTokens == null) {
            this.accessTokens = new ArrayList<String>();
        }
        this.accessTokens.add(accessTokensItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of access tokens associated with the items to update in Link update mode for the Assets product. Using this instead of the `access_token` field allows the updating of multiple items at once. This feature is in closed beta, please contact your account manager for more info.")
    public List<String> getAccessTokens() {
        return this.accessTokens;
    }

    public void setAccessTokens(List<String> accessTokens) {
        this.accessTokens = accessTokens;
    }

    public LinkTokenCreateRequest linkCustomizationName(String linkCustomizationName) {
        this.linkCustomizationName = linkCustomizationName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the Link customization from the Plaid Dashboard to be applied to Link. If not specified, the `default` customization will be used. When using a Link customization, the language in the customization must match the language selected via the `language` parameter, and the countries in the customization should match the country codes selected via `country_codes`.")
    public String getLinkCustomizationName() {
        return this.linkCustomizationName;
    }

    public void setLinkCustomizationName(String linkCustomizationName) {
        this.linkCustomizationName = linkCustomizationName;
    }

    public LinkTokenCreateRequest redirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A URI indicating the destination where a user should be forwarded after completing the Link flow; used to support OAuth authentication flows when launching Link in the browser or another app. The `redirect_uri` should not contain any query parameters. When used in Production, must be an https URI. To specify any subdomain, use `*` as a wildcard character, e.g. `https://_*.example.com/oauth.html`. Note that any redirect URI must also be added to the Allowed redirect URIs list in the [developer dashboard](https://dashboard.plaid.com/team/api). If initializing on Android, `android_package_name` must be specified instead and `redirect_uri` should be left blank. If using Hosted Link, the `redirect_uri` must be set to `https://secure.plaid.com/oauth/redirect`.")
    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public LinkTokenCreateRequest androidPackageName(String androidPackageName) {
        this.androidPackageName = androidPackageName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of your app's Android package. Required if using the `link_token` to initialize Link on Android. Any package name specified here must also be added to the Allowed Android package names setting on the [developer dashboard](https://dashboard.plaid.com/team/api). When creating a `link_token` for initializing Link on other platforms, `android_package_name` must be left blank and `redirect_uri` should be used instead.")
    public String getAndroidPackageName() {
        return this.androidPackageName;
    }

    public void setAndroidPackageName(String androidPackageName) {
        this.androidPackageName = androidPackageName;
    }

    public LinkTokenCreateRequest institutionData(LinkTokenCreateInstitutionData institutionData) {
        this.institutionData = institutionData;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateInstitutionData getInstitutionData() {
        return this.institutionData;
    }

    public void setInstitutionData(LinkTokenCreateInstitutionData institutionData) {
        this.institutionData = institutionData;
    }

    public LinkTokenCreateRequest cardSwitch(LinkTokenCreateCardSwitch cardSwitch) {
        this.cardSwitch = cardSwitch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateCardSwitch getCardSwitch() {
        return this.cardSwitch;
    }

    public void setCardSwitch(LinkTokenCreateCardSwitch cardSwitch) {
        this.cardSwitch = cardSwitch;
    }

    public LinkTokenCreateRequest accountFilters(LinkTokenAccountFilters accountFilters) {
        this.accountFilters = accountFilters;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenAccountFilters getAccountFilters() {
        return this.accountFilters;
    }

    public void setAccountFilters(LinkTokenAccountFilters accountFilters) {
        this.accountFilters = accountFilters;
    }

    public LinkTokenCreateRequest euConfig(LinkTokenEUConfig euConfig) {
        this.euConfig = euConfig;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenEUConfig getEuConfig() {
        return this.euConfig;
    }

    public void setEuConfig(LinkTokenEUConfig euConfig) {
        this.euConfig = euConfig;
    }

    public LinkTokenCreateRequest institutionId(String institutionId) {
        this.institutionId = institutionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used for certain Europe-only configurations, as well as certain legacy use cases in other regions.")
    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public LinkTokenCreateRequest paymentInitiation(LinkTokenCreateRequestPaymentInitiation paymentInitiation) {
        this.paymentInitiation = paymentInitiation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateRequestPaymentInitiation getPaymentInitiation() {
        return this.paymentInitiation;
    }

    public void setPaymentInitiation(LinkTokenCreateRequestPaymentInitiation paymentInitiation) {
        this.paymentInitiation = paymentInitiation;
    }

    public LinkTokenCreateRequest depositSwitch(LinkTokenCreateRequestDepositSwitch depositSwitch) {
        this.depositSwitch = depositSwitch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateRequestDepositSwitch getDepositSwitch() {
        return this.depositSwitch;
    }

    public void setDepositSwitch(LinkTokenCreateRequestDepositSwitch depositSwitch) {
        this.depositSwitch = depositSwitch;
    }

    public LinkTokenCreateRequest employment(LinkTokenCreateRequestEmployment employment) {
        this.employment = employment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateRequestEmployment getEmployment() {
        return this.employment;
    }

    public void setEmployment(LinkTokenCreateRequestEmployment employment) {
        this.employment = employment;
    }

    public LinkTokenCreateRequest incomeVerification(LinkTokenCreateRequestIncomeVerification incomeVerification) {
        this.incomeVerification = incomeVerification;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateRequestIncomeVerification getIncomeVerification() {
        return this.incomeVerification;
    }

    public void setIncomeVerification(LinkTokenCreateRequestIncomeVerification incomeVerification) {
        this.incomeVerification = incomeVerification;
    }

    public LinkTokenCreateRequest baseReport(LinkTokenCreateRequestBaseReport baseReport) {
        this.baseReport = baseReport;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateRequestBaseReport getBaseReport() {
        return this.baseReport;
    }

    public void setBaseReport(LinkTokenCreateRequestBaseReport baseReport) {
        this.baseReport = baseReport;
    }

    public LinkTokenCreateRequest creditPartnerInsights(LinkTokenCreateRequestCreditPartnerInsights creditPartnerInsights) {
        this.creditPartnerInsights = creditPartnerInsights;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateRequestCreditPartnerInsights getCreditPartnerInsights() {
        return this.creditPartnerInsights;
    }

    public void setCreditPartnerInsights(LinkTokenCreateRequestCreditPartnerInsights creditPartnerInsights) {
        this.creditPartnerInsights = creditPartnerInsights;
    }

    public LinkTokenCreateRequest craOptions(LinkTokenCreateRequestCraOptions craOptions) {
        this.craOptions = craOptions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateRequestCraOptions getCraOptions() {
        return this.craOptions;
    }

    public void setCraOptions(LinkTokenCreateRequestCraOptions craOptions) {
        this.craOptions = craOptions;
    }

    public LinkTokenCreateRequest consumerReportPermissiblePurpose(ConsumerReportPermissiblePurpose consumerReportPermissiblePurpose) {
        this.consumerReportPermissiblePurpose = consumerReportPermissiblePurpose;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ConsumerReportPermissiblePurpose getConsumerReportPermissiblePurpose() {
        return this.consumerReportPermissiblePurpose;
    }

    public void setConsumerReportPermissiblePurpose(ConsumerReportPermissiblePurpose consumerReportPermissiblePurpose) {
        this.consumerReportPermissiblePurpose = consumerReportPermissiblePurpose;
    }

    public LinkTokenCreateRequest auth(LinkTokenCreateRequestAuth auth) {
        this.auth = auth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateRequestAuth getAuth() {
        return this.auth;
    }

    public void setAuth(LinkTokenCreateRequestAuth auth) {
        this.auth = auth;
    }

    public LinkTokenCreateRequest transfer(LinkTokenCreateRequestTransfer transfer) {
        this.transfer = transfer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateRequestTransfer getTransfer() {
        return this.transfer;
    }

    public void setTransfer(LinkTokenCreateRequestTransfer transfer) {
        this.transfer = transfer;
    }

    public LinkTokenCreateRequest update(LinkTokenCreateRequestUpdate update) {
        this.update = update;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateRequestUpdate getUpdate() {
        return this.update;
    }

    public void setUpdate(LinkTokenCreateRequestUpdate update) {
        this.update = update;
    }

    public LinkTokenCreateRequest identityVerification(LinkTokenCreateRequestIdentityVerification identityVerification) {
        this.identityVerification = identityVerification;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateRequestIdentityVerification getIdentityVerification() {
        return this.identityVerification;
    }

    public void setIdentityVerification(LinkTokenCreateRequestIdentityVerification identityVerification) {
        this.identityVerification = identityVerification;
    }

    public LinkTokenCreateRequest statements(LinkTokenCreateRequestStatements statements) {
        this.statements = statements;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateRequestStatements getStatements() {
        return this.statements;
    }

    public void setStatements(LinkTokenCreateRequestStatements statements) {
        this.statements = statements;
    }

    public LinkTokenCreateRequest userToken(String userToken) {
        this.userToken = userToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A user token generated using `/user/create`. Any Item created during the Link session will be associated with the user.")
    public String getUserToken() {
        return this.userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public LinkTokenCreateRequest investments(LinkTokenInvestments investments) {
        this.investments = investments;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenInvestments getInvestments() {
        return this.investments;
    }

    public void setInvestments(LinkTokenInvestments investments) {
        this.investments = investments;
    }

    public LinkTokenCreateRequest investmentsAuth(LinkTokenInvestmentsAuth investmentsAuth) {
        this.investmentsAuth = investmentsAuth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenInvestmentsAuth getInvestmentsAuth() {
        return this.investmentsAuth;
    }

    public void setInvestmentsAuth(LinkTokenInvestmentsAuth investmentsAuth) {
        this.investmentsAuth = investmentsAuth;
    }

    public LinkTokenCreateRequest hostedLink(LinkTokenCreateHostedLink hostedLink) {
        this.hostedLink = hostedLink;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateHostedLink getHostedLink() {
        return this.hostedLink;
    }

    public void setHostedLink(LinkTokenCreateHostedLink hostedLink) {
        this.hostedLink = hostedLink;
    }

    public LinkTokenCreateRequest transactions(LinkTokenTransactions transactions) {
        this.transactions = transactions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenTransactions getTransactions() {
        return this.transactions;
    }

    public void setTransactions(LinkTokenTransactions transactions) {
        this.transactions = transactions;
    }

    public LinkTokenCreateRequest craEnabled(Boolean craEnabled) {
        this.craEnabled = craEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If `true`, request a CRA connection. Defaults to `false`.")
    public Boolean getCraEnabled() {
        return this.craEnabled;
    }

    public void setCraEnabled(Boolean craEnabled) {
        this.craEnabled = craEnabled;
    }

    public LinkTokenCreateRequest identity(LinkTokenCreateIdentity identity) {
        this.identity = identity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateIdentity getIdentity() {
        return this.identity;
    }

    public void setIdentity(LinkTokenCreateIdentity identity) {
        this.identity = identity;
    }

    public LinkTokenCreateRequest financekitSupported(Boolean financekitSupported) {
        this.financekitSupported = financekitSupported;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If `true`, indicates that client supports linking FinanceKit / AppleCard items. Defaults to `false`.")
    public Boolean getFinancekitSupported() {
        return this.financekitSupported;
    }

    public void setFinancekitSupported(Boolean financekitSupported) {
        this.financekitSupported = financekitSupported;
    }

    public LinkTokenCreateRequest enableMultiItemLink(Boolean enableMultiItemLink) {
        this.enableMultiItemLink = enableMultiItemLink;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If `true`, enable linking multiple items in the same Link session. Defaults to `false`.")
    public Boolean getEnableMultiItemLink() {
        return this.enableMultiItemLink;
    }

    public void setEnableMultiItemLink(Boolean enableMultiItemLink) {
        this.enableMultiItemLink = enableMultiItemLink;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkTokenCreateRequest linkTokenCreateRequest = (LinkTokenCreateRequest)o;
        return Objects.equals(this.clientId, linkTokenCreateRequest.clientId) && Objects.equals(this.secret, linkTokenCreateRequest.secret) && Objects.equals(this.clientName, linkTokenCreateRequest.clientName) && Objects.equals(this.language, linkTokenCreateRequest.language) && Objects.equals(this.countryCodes, linkTokenCreateRequest.countryCodes) && Objects.equals(this.user, linkTokenCreateRequest.user) && Objects.equals(this.products, linkTokenCreateRequest.products) && Objects.equals(this.requiredIfSupportedProducts, linkTokenCreateRequest.requiredIfSupportedProducts) && Objects.equals(this.optionalProducts, linkTokenCreateRequest.optionalProducts) && Objects.equals(this.additionalConsentedProducts, linkTokenCreateRequest.additionalConsentedProducts) && Objects.equals(this.webhook, linkTokenCreateRequest.webhook) && Objects.equals(this.accessToken, linkTokenCreateRequest.accessToken) && Objects.equals(this.accessTokens, linkTokenCreateRequest.accessTokens) && Objects.equals(this.linkCustomizationName, linkTokenCreateRequest.linkCustomizationName) && Objects.equals(this.redirectUri, linkTokenCreateRequest.redirectUri) && Objects.equals(this.androidPackageName, linkTokenCreateRequest.androidPackageName) && Objects.equals(this.institutionData, linkTokenCreateRequest.institutionData) && Objects.equals(this.cardSwitch, linkTokenCreateRequest.cardSwitch) && Objects.equals(this.accountFilters, linkTokenCreateRequest.accountFilters) && Objects.equals(this.euConfig, linkTokenCreateRequest.euConfig) && Objects.equals(this.institutionId, linkTokenCreateRequest.institutionId) && Objects.equals(this.paymentInitiation, linkTokenCreateRequest.paymentInitiation) && Objects.equals(this.depositSwitch, linkTokenCreateRequest.depositSwitch) && Objects.equals(this.employment, linkTokenCreateRequest.employment) && Objects.equals(this.incomeVerification, linkTokenCreateRequest.incomeVerification) && Objects.equals(this.baseReport, linkTokenCreateRequest.baseReport) && Objects.equals(this.creditPartnerInsights, linkTokenCreateRequest.creditPartnerInsights) && Objects.equals(this.craOptions, linkTokenCreateRequest.craOptions) && Objects.equals((Object)this.consumerReportPermissiblePurpose, (Object)linkTokenCreateRequest.consumerReportPermissiblePurpose) && Objects.equals(this.auth, linkTokenCreateRequest.auth) && Objects.equals(this.transfer, linkTokenCreateRequest.transfer) && Objects.equals(this.update, linkTokenCreateRequest.update) && Objects.equals(this.identityVerification, linkTokenCreateRequest.identityVerification) && Objects.equals(this.statements, linkTokenCreateRequest.statements) && Objects.equals(this.userToken, linkTokenCreateRequest.userToken) && Objects.equals(this.investments, linkTokenCreateRequest.investments) && Objects.equals(this.investmentsAuth, linkTokenCreateRequest.investmentsAuth) && Objects.equals(this.hostedLink, linkTokenCreateRequest.hostedLink) && Objects.equals(this.transactions, linkTokenCreateRequest.transactions) && Objects.equals(this.craEnabled, linkTokenCreateRequest.craEnabled) && Objects.equals(this.identity, linkTokenCreateRequest.identity) && Objects.equals(this.financekitSupported, linkTokenCreateRequest.financekitSupported) && Objects.equals(this.enableMultiItemLink, linkTokenCreateRequest.enableMultiItemLink);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.clientName, this.language, this.countryCodes, this.user, this.products, this.requiredIfSupportedProducts, this.optionalProducts, this.additionalConsentedProducts, this.webhook, this.accessToken, this.accessTokens, this.linkCustomizationName, this.redirectUri, this.androidPackageName, this.institutionData, this.cardSwitch, this.accountFilters, this.euConfig, this.institutionId, this.paymentInitiation, this.depositSwitch, this.employment, this.incomeVerification, this.baseReport, this.creditPartnerInsights, this.craOptions, this.consumerReportPermissiblePurpose, this.auth, this.transfer, this.update, this.identityVerification, this.statements, this.userToken, this.investments, this.investmentsAuth, this.hostedLink, this.transactions, this.craEnabled, this.identity, this.financekitSupported, this.enableMultiItemLink});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkTokenCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    clientName: ").append(this.toIndentedString(this.clientName)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    countryCodes: ").append(this.toIndentedString(this.countryCodes)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    products: ").append(this.toIndentedString(this.products)).append("\n");
        sb.append("    requiredIfSupportedProducts: ").append(this.toIndentedString(this.requiredIfSupportedProducts)).append("\n");
        sb.append("    optionalProducts: ").append(this.toIndentedString(this.optionalProducts)).append("\n");
        sb.append("    additionalConsentedProducts: ").append(this.toIndentedString(this.additionalConsentedProducts)).append("\n");
        sb.append("    webhook: ").append(this.toIndentedString(this.webhook)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    accessTokens: ").append(this.toIndentedString(this.accessTokens)).append("\n");
        sb.append("    linkCustomizationName: ").append(this.toIndentedString(this.linkCustomizationName)).append("\n");
        sb.append("    redirectUri: ").append(this.toIndentedString(this.redirectUri)).append("\n");
        sb.append("    androidPackageName: ").append(this.toIndentedString(this.androidPackageName)).append("\n");
        sb.append("    institutionData: ").append(this.toIndentedString(this.institutionData)).append("\n");
        sb.append("    cardSwitch: ").append(this.toIndentedString(this.cardSwitch)).append("\n");
        sb.append("    accountFilters: ").append(this.toIndentedString(this.accountFilters)).append("\n");
        sb.append("    euConfig: ").append(this.toIndentedString(this.euConfig)).append("\n");
        sb.append("    institutionId: ").append(this.toIndentedString(this.institutionId)).append("\n");
        sb.append("    paymentInitiation: ").append(this.toIndentedString(this.paymentInitiation)).append("\n");
        sb.append("    depositSwitch: ").append(this.toIndentedString(this.depositSwitch)).append("\n");
        sb.append("    employment: ").append(this.toIndentedString(this.employment)).append("\n");
        sb.append("    incomeVerification: ").append(this.toIndentedString(this.incomeVerification)).append("\n");
        sb.append("    baseReport: ").append(this.toIndentedString(this.baseReport)).append("\n");
        sb.append("    creditPartnerInsights: ").append(this.toIndentedString(this.creditPartnerInsights)).append("\n");
        sb.append("    craOptions: ").append(this.toIndentedString(this.craOptions)).append("\n");
        sb.append("    consumerReportPermissiblePurpose: ").append(this.toIndentedString((Object)this.consumerReportPermissiblePurpose)).append("\n");
        sb.append("    auth: ").append(this.toIndentedString(this.auth)).append("\n");
        sb.append("    transfer: ").append(this.toIndentedString(this.transfer)).append("\n");
        sb.append("    update: ").append(this.toIndentedString(this.update)).append("\n");
        sb.append("    identityVerification: ").append(this.toIndentedString(this.identityVerification)).append("\n");
        sb.append("    statements: ").append(this.toIndentedString(this.statements)).append("\n");
        sb.append("    userToken: ").append(this.toIndentedString(this.userToken)).append("\n");
        sb.append("    investments: ").append(this.toIndentedString(this.investments)).append("\n");
        sb.append("    investmentsAuth: ").append(this.toIndentedString(this.investmentsAuth)).append("\n");
        sb.append("    hostedLink: ").append(this.toIndentedString(this.hostedLink)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("    craEnabled: ").append(this.toIndentedString(this.craEnabled)).append("\n");
        sb.append("    identity: ").append(this.toIndentedString(this.identity)).append("\n");
        sb.append("    financekitSupported: ").append(this.toIndentedString(this.financekitSupported)).append("\n");
        sb.append("    enableMultiItemLink: ").append(this.toIndentedString(this.enableMultiItemLink)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

