/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.LinkTokenCreateCreditFilter;
import com.plaid.client.model.LinkTokenCreateDepositoryFilter;
import com.plaid.client.model.LinkTokenCreateInvestmentFilter;
import com.plaid.client.model.LinkTokenCreateLoanFilter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="By default, Link will only display account types that are compatible with all products supplied in the `products` parameter of `/link/token/create`. You can further limit the accounts shown in Link by using `account_filters` to specify the account subtypes to be shown in Link. Only the specified subtypes will be shown. This filtering applies to both the Account Select view (if enabled) and the Institution Select view. Institutions that do not support the selected subtypes will be omitted from Link. To indicate that all subtypes should be shown, use the value `\"all\"`. If the `account_filters` filter is used, any account type for which a filter is not specified will be entirely omitted from Link.  For a full list of valid types and subtypes, see the [Account schema](https://plaid.com/docs/api/accounts#account-type-schema).  For institutions using OAuth, the filter will not affect the list of institutions or accounts shown by the bank in the OAuth window. ")
public class LinkTokenCreateRequestAccountSubtypes {
    public static final String SERIALIZED_NAME_DEPOSITORY = "depository";
    @SerializedName(value="depository")
    private LinkTokenCreateDepositoryFilter depository;
    public static final String SERIALIZED_NAME_CREDIT = "credit";
    @SerializedName(value="credit")
    private LinkTokenCreateCreditFilter credit;
    public static final String SERIALIZED_NAME_LOAN = "loan";
    @SerializedName(value="loan")
    private LinkTokenCreateLoanFilter loan;
    public static final String SERIALIZED_NAME_INVESTMENT = "investment";
    @SerializedName(value="investment")
    private LinkTokenCreateInvestmentFilter investment;

    public LinkTokenCreateRequestAccountSubtypes depository(LinkTokenCreateDepositoryFilter depository) {
        this.depository = depository;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateDepositoryFilter getDepository() {
        return this.depository;
    }

    public void setDepository(LinkTokenCreateDepositoryFilter depository) {
        this.depository = depository;
    }

    public LinkTokenCreateRequestAccountSubtypes credit(LinkTokenCreateCreditFilter credit) {
        this.credit = credit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateCreditFilter getCredit() {
        return this.credit;
    }

    public void setCredit(LinkTokenCreateCreditFilter credit) {
        this.credit = credit;
    }

    public LinkTokenCreateRequestAccountSubtypes loan(LinkTokenCreateLoanFilter loan) {
        this.loan = loan;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateLoanFilter getLoan() {
        return this.loan;
    }

    public void setLoan(LinkTokenCreateLoanFilter loan) {
        this.loan = loan;
    }

    public LinkTokenCreateRequestAccountSubtypes investment(LinkTokenCreateInvestmentFilter investment) {
        this.investment = investment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateInvestmentFilter getInvestment() {
        return this.investment;
    }

    public void setInvestment(LinkTokenCreateInvestmentFilter investment) {
        this.investment = investment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkTokenCreateRequestAccountSubtypes linkTokenCreateRequestAccountSubtypes = (LinkTokenCreateRequestAccountSubtypes)o;
        return Objects.equals(this.depository, linkTokenCreateRequestAccountSubtypes.depository) && Objects.equals(this.credit, linkTokenCreateRequestAccountSubtypes.credit) && Objects.equals(this.loan, linkTokenCreateRequestAccountSubtypes.loan) && Objects.equals(this.investment, linkTokenCreateRequestAccountSubtypes.investment);
    }

    public int hashCode() {
        return Objects.hash(this.depository, this.credit, this.loan, this.investment);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkTokenCreateRequestAccountSubtypes {\n");
        sb.append("    depository: ").append(this.toIndentedString(this.depository)).append("\n");
        sb.append("    credit: ").append(this.toIndentedString(this.credit)).append("\n");
        sb.append("    loan: ").append(this.toIndentedString(this.loan)).append("\n");
        sb.append("    investment: ").append(this.toIndentedString(this.investment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

