/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specifies options for initializing Link for use with the Auth product. This field can be used to enable or disable extended Auth flows for the resulting Link session. Omitting any field will result in a default that can be configured by your account manager. The default behavior described in the documentation is the default behavior that will apply if you have not requested your account manager to apply a different default.")
public class LinkTokenCreateRequestAuth {
    public static final String SERIALIZED_NAME_AUTH_TYPE_SELECT_ENABLED = "auth_type_select_enabled";
    @SerializedName(value="auth_type_select_enabled")
    private Boolean authTypeSelectEnabled;
    public static final String SERIALIZED_NAME_AUTOMATED_MICRODEPOSITS_ENABLED = "automated_microdeposits_enabled";
    @SerializedName(value="automated_microdeposits_enabled")
    private Boolean automatedMicrodepositsEnabled;
    public static final String SERIALIZED_NAME_INSTANT_MATCH_ENABLED = "instant_match_enabled";
    @SerializedName(value="instant_match_enabled")
    private Boolean instantMatchEnabled;
    public static final String SERIALIZED_NAME_SAME_DAY_MICRODEPOSITS_ENABLED = "same_day_microdeposits_enabled";
    @SerializedName(value="same_day_microdeposits_enabled")
    private Boolean sameDayMicrodepositsEnabled;
    public static final String SERIALIZED_NAME_INSTANT_MICRODEPOSITS_ENABLED = "instant_microdeposits_enabled";
    @SerializedName(value="instant_microdeposits_enabled")
    private Boolean instantMicrodepositsEnabled;
    public static final String SERIALIZED_NAME_REROUTE_TO_CREDENTIALS = "reroute_to_credentials";
    @SerializedName(value="reroute_to_credentials")
    private RerouteToCredentialsEnum rerouteToCredentials;
    public static final String SERIALIZED_NAME_DATABASE_MATCH_ENABLED = "database_match_enabled";
    @SerializedName(value="database_match_enabled")
    private Boolean databaseMatchEnabled;
    public static final String SERIALIZED_NAME_DATABASE_INSIGHTS_ENABLED = "database_insights_enabled";
    @SerializedName(value="database_insights_enabled")
    private Boolean databaseInsightsEnabled;
    public static final String SERIALIZED_NAME_FLOW_TYPE = "flow_type";
    @SerializedName(value="flow_type")
    private FlowTypeEnum flowType;
    public static final String SERIALIZED_NAME_SMS_MICRODEPOSITS_VERIFICATION_ENABLED = "sms_microdeposits_verification_enabled";
    @SerializedName(value="sms_microdeposits_verification_enabled")
    private Boolean smsMicrodepositsVerificationEnabled;

    public LinkTokenCreateRequestAuth authTypeSelectEnabled(Boolean authTypeSelectEnabled) {
        this.authTypeSelectEnabled = authTypeSelectEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies whether Auth Type Select is enabled for the Link session, allowing the end user to choose between linking via a credentials-based flow (i.e. Instant Auth, Instant Match, Automated Micro-deposits) or a manual flow that does not require login (all other Auth flows) prior to selecting their financial institution. Default behavior is `false`.")
    public Boolean getAuthTypeSelectEnabled() {
        return this.authTypeSelectEnabled;
    }

    public void setAuthTypeSelectEnabled(Boolean authTypeSelectEnabled) {
        this.authTypeSelectEnabled = authTypeSelectEnabled;
    }

    public LinkTokenCreateRequestAuth automatedMicrodepositsEnabled(Boolean automatedMicrodepositsEnabled) {
        this.automatedMicrodepositsEnabled = automatedMicrodepositsEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies whether the Link session is enabled for the Automated Micro-deposits flow. Default behavior is `false`.")
    public Boolean getAutomatedMicrodepositsEnabled() {
        return this.automatedMicrodepositsEnabled;
    }

    public void setAutomatedMicrodepositsEnabled(Boolean automatedMicrodepositsEnabled) {
        this.automatedMicrodepositsEnabled = automatedMicrodepositsEnabled;
    }

    public LinkTokenCreateRequestAuth instantMatchEnabled(Boolean instantMatchEnabled) {
        this.instantMatchEnabled = instantMatchEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies whether the Link session is enabled for the Instant Match flow. Instant Match is enabled by default. Instant Match can be disabled by setting this field to `false`.")
    public Boolean getInstantMatchEnabled() {
        return this.instantMatchEnabled;
    }

    public void setInstantMatchEnabled(Boolean instantMatchEnabled) {
        this.instantMatchEnabled = instantMatchEnabled;
    }

    public LinkTokenCreateRequestAuth sameDayMicrodepositsEnabled(Boolean sameDayMicrodepositsEnabled) {
        this.sameDayMicrodepositsEnabled = sameDayMicrodepositsEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies whether the Link session is enabled for the Same Day Micro-deposits flow.  Default behavior is `false`.")
    public Boolean getSameDayMicrodepositsEnabled() {
        return this.sameDayMicrodepositsEnabled;
    }

    public void setSameDayMicrodepositsEnabled(Boolean sameDayMicrodepositsEnabled) {
        this.sameDayMicrodepositsEnabled = sameDayMicrodepositsEnabled;
    }

    public LinkTokenCreateRequestAuth instantMicrodepositsEnabled(Boolean instantMicrodepositsEnabled) {
        this.instantMicrodepositsEnabled = instantMicrodepositsEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies whether the Link session is enabled for the Instant Micro-deposits flow.  Default behavior for Plaid teams created after November 2023 is `false`; default behavior for Plaid teams created before that date is `true`.")
    public Boolean getInstantMicrodepositsEnabled() {
        return this.instantMicrodepositsEnabled;
    }

    public void setInstantMicrodepositsEnabled(Boolean instantMicrodepositsEnabled) {
        this.instantMicrodepositsEnabled = instantMicrodepositsEnabled;
    }

    public LinkTokenCreateRequestAuth rerouteToCredentials(RerouteToCredentialsEnum rerouteToCredentials) {
        this.rerouteToCredentials = rerouteToCredentials;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies what type of [Reroute to Credentials](https://plaid.com/docs/auth/coverage/same-day/#reroute-to-credentials) pane should be used in the Link session for the Same Day Micro-deposits flow. Default behavior is `OPTIONAL`.")
    public RerouteToCredentialsEnum getRerouteToCredentials() {
        return this.rerouteToCredentials;
    }

    public void setRerouteToCredentials(RerouteToCredentialsEnum rerouteToCredentials) {
        this.rerouteToCredentials = rerouteToCredentials;
    }

    public LinkTokenCreateRequestAuth databaseMatchEnabled(Boolean databaseMatchEnabled) {
        this.databaseMatchEnabled = databaseMatchEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies whether the Link session is enabled for the Database Match flow. Default behavior is `false`.")
    public Boolean getDatabaseMatchEnabled() {
        return this.databaseMatchEnabled;
    }

    public void setDatabaseMatchEnabled(Boolean databaseMatchEnabled) {
        this.databaseMatchEnabled = databaseMatchEnabled;
    }

    public LinkTokenCreateRequestAuth databaseInsightsEnabled(Boolean databaseInsightsEnabled) {
        this.databaseInsightsEnabled = databaseInsightsEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies whether the Link session is enabled for the Database Insights flow. Database Insights is currently in closed beta; for access, contact your Account Manager. Default behavior is `false`.")
    public Boolean getDatabaseInsightsEnabled() {
        return this.databaseInsightsEnabled;
    }

    public void setDatabaseInsightsEnabled(Boolean databaseInsightsEnabled) {
        this.databaseInsightsEnabled = databaseInsightsEnabled;
    }

    public LinkTokenCreateRequestAuth flowType(FlowTypeEnum flowType) {
        this.flowType = flowType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This field has been deprecated in favor of `auth_type_select_enabled`.")
    public FlowTypeEnum getFlowType() {
        return this.flowType;
    }

    public void setFlowType(FlowTypeEnum flowType) {
        this.flowType = flowType;
    }

    public LinkTokenCreateRequestAuth smsMicrodepositsVerificationEnabled(Boolean smsMicrodepositsVerificationEnabled) {
        this.smsMicrodepositsVerificationEnabled = smsMicrodepositsVerificationEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies whether the Link session is enabled for SMS micro-deposits verification. Default behavior is `true`.")
    public Boolean getSmsMicrodepositsVerificationEnabled() {
        return this.smsMicrodepositsVerificationEnabled;
    }

    public void setSmsMicrodepositsVerificationEnabled(Boolean smsMicrodepositsVerificationEnabled) {
        this.smsMicrodepositsVerificationEnabled = smsMicrodepositsVerificationEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkTokenCreateRequestAuth linkTokenCreateRequestAuth = (LinkTokenCreateRequestAuth)o;
        return Objects.equals(this.authTypeSelectEnabled, linkTokenCreateRequestAuth.authTypeSelectEnabled) && Objects.equals(this.automatedMicrodepositsEnabled, linkTokenCreateRequestAuth.automatedMicrodepositsEnabled) && Objects.equals(this.instantMatchEnabled, linkTokenCreateRequestAuth.instantMatchEnabled) && Objects.equals(this.sameDayMicrodepositsEnabled, linkTokenCreateRequestAuth.sameDayMicrodepositsEnabled) && Objects.equals(this.instantMicrodepositsEnabled, linkTokenCreateRequestAuth.instantMicrodepositsEnabled) && Objects.equals((Object)this.rerouteToCredentials, (Object)linkTokenCreateRequestAuth.rerouteToCredentials) && Objects.equals(this.databaseMatchEnabled, linkTokenCreateRequestAuth.databaseMatchEnabled) && Objects.equals(this.databaseInsightsEnabled, linkTokenCreateRequestAuth.databaseInsightsEnabled) && Objects.equals((Object)this.flowType, (Object)linkTokenCreateRequestAuth.flowType) && Objects.equals(this.smsMicrodepositsVerificationEnabled, linkTokenCreateRequestAuth.smsMicrodepositsVerificationEnabled);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authTypeSelectEnabled, this.automatedMicrodepositsEnabled, this.instantMatchEnabled, this.sameDayMicrodepositsEnabled, this.instantMicrodepositsEnabled, this.rerouteToCredentials, this.databaseMatchEnabled, this.databaseInsightsEnabled, this.flowType, this.smsMicrodepositsVerificationEnabled});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkTokenCreateRequestAuth {\n");
        sb.append("    authTypeSelectEnabled: ").append(this.toIndentedString(this.authTypeSelectEnabled)).append("\n");
        sb.append("    automatedMicrodepositsEnabled: ").append(this.toIndentedString(this.automatedMicrodepositsEnabled)).append("\n");
        sb.append("    instantMatchEnabled: ").append(this.toIndentedString(this.instantMatchEnabled)).append("\n");
        sb.append("    sameDayMicrodepositsEnabled: ").append(this.toIndentedString(this.sameDayMicrodepositsEnabled)).append("\n");
        sb.append("    instantMicrodepositsEnabled: ").append(this.toIndentedString(this.instantMicrodepositsEnabled)).append("\n");
        sb.append("    rerouteToCredentials: ").append(this.toIndentedString((Object)this.rerouteToCredentials)).append("\n");
        sb.append("    databaseMatchEnabled: ").append(this.toIndentedString(this.databaseMatchEnabled)).append("\n");
        sb.append("    databaseInsightsEnabled: ").append(this.toIndentedString(this.databaseInsightsEnabled)).append("\n");
        sb.append("    flowType: ").append(this.toIndentedString((Object)this.flowType)).append("\n");
        sb.append("    smsMicrodepositsVerificationEnabled: ").append(this.toIndentedString(this.smsMicrodepositsVerificationEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FlowTypeEnum {
        FLEXIBLE_AUTH("FLEXIBLE_AUTH");

        private String value;

        private FlowTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FlowTypeEnum fromValue(String value) {
            for (FlowTypeEnum b : FlowTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<FlowTypeEnum> {
            public void write(JsonWriter jsonWriter, FlowTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FlowTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FlowTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RerouteToCredentialsEnum {
        OFF("OFF"),
        OPTIONAL("OPTIONAL"),
        FORCED("FORCED");

        private String value;

        private RerouteToCredentialsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RerouteToCredentialsEnum fromValue(String value) {
            for (RerouteToCredentialsEnum b : RerouteToCredentialsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RerouteToCredentialsEnum> {
            public void write(JsonWriter jsonWriter, RerouteToCredentialsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RerouteToCredentialsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RerouteToCredentialsEnum.fromValue(value);
            }
        }
    }
}

