/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PrismProduct;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specifies options for initializing Link for use with the Credit Partner Insights product.")
public class LinkTokenCreateRequestCreditPartnerInsights {
    public static final String SERIALIZED_NAME_DAYS_REQUESTED = "days_requested";
    @SerializedName(value="days_requested")
    private Integer daysRequested;
    public static final String SERIALIZED_NAME_PRISM_PRODUCTS = "prism_products";
    @SerializedName(value="prism_products")
    private List<PrismProduct> prismProducts = null;

    public LinkTokenCreateRequestCreditPartnerInsights daysRequested(Integer daysRequested) {
        this.daysRequested = daysRequested;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum integer number of days of history to compute Crdit Partner Insights. Defaults to 180 if not specified")
    public Integer getDaysRequested() {
        return this.daysRequested;
    }

    public void setDaysRequested(Integer daysRequested) {
        this.daysRequested = daysRequested;
    }

    public LinkTokenCreateRequestCreditPartnerInsights prismProducts(List<PrismProduct> prismProducts) {
        this.prismProducts = prismProducts;
        return this;
    }

    public LinkTokenCreateRequestCreditPartnerInsights addPrismProductsItem(PrismProduct prismProductsItem) {
        if (this.prismProducts == null) {
            this.prismProducts = new ArrayList<PrismProduct>();
        }
        this.prismProducts.add(prismProductsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The specific Prism products to return. If none are passed in, then all products will be returned.")
    public List<PrismProduct> getPrismProducts() {
        return this.prismProducts;
    }

    public void setPrismProducts(List<PrismProduct> prismProducts) {
        this.prismProducts = prismProducts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkTokenCreateRequestCreditPartnerInsights linkTokenCreateRequestCreditPartnerInsights = (LinkTokenCreateRequestCreditPartnerInsights)o;
        return Objects.equals(this.daysRequested, linkTokenCreateRequestCreditPartnerInsights.daysRequested) && Objects.equals(this.prismProducts, linkTokenCreateRequestCreditPartnerInsights.prismProducts);
    }

    public int hashCode() {
        return Objects.hash(this.daysRequested, this.prismProducts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkTokenCreateRequestCreditPartnerInsights {\n");
        sb.append("    daysRequested: ").append(this.toIndentedString(this.daysRequested)).append("\n");
        sb.append("    prismProducts: ").append(this.toIndentedString(this.prismProducts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

