/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IncomeVerificationSourceType;
import com.plaid.client.model.LinkTokenCreateRequestIncomeVerificationBankIncome;
import com.plaid.client.model.LinkTokenCreateRequestIncomeVerificationPayrollIncome;
import com.plaid.client.model.LinkTokenCreateRequestUserStatedIncomeSource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specifies options for initializing Link for use with the Income product. This field is required if `income_verification` is included in the `products` array.")
public class LinkTokenCreateRequestIncomeVerification {
    public static final String SERIALIZED_NAME_INCOME_VERIFICATION_ID = "income_verification_id";
    @SerializedName(value="income_verification_id")
    private String incomeVerificationId;
    public static final String SERIALIZED_NAME_ASSET_REPORT_ID = "asset_report_id";
    @SerializedName(value="asset_report_id")
    private String assetReportId;
    public static final String SERIALIZED_NAME_ACCESS_TOKENS = "access_tokens";
    @SerializedName(value="access_tokens")
    private List<String> accessTokens = null;
    public static final String SERIALIZED_NAME_INCOME_SOURCE_TYPES = "income_source_types";
    @SerializedName(value="income_source_types")
    private List<IncomeVerificationSourceType> incomeSourceTypes = null;
    public static final String SERIALIZED_NAME_BANK_INCOME = "bank_income";
    @SerializedName(value="bank_income")
    private LinkTokenCreateRequestIncomeVerificationBankIncome bankIncome;
    public static final String SERIALIZED_NAME_PAYROLL_INCOME = "payroll_income";
    @SerializedName(value="payroll_income")
    private LinkTokenCreateRequestIncomeVerificationPayrollIncome payrollIncome;
    public static final String SERIALIZED_NAME_STATED_INCOME_SOURCES = "stated_income_sources";
    @SerializedName(value="stated_income_sources")
    private List<LinkTokenCreateRequestUserStatedIncomeSource> statedIncomeSources = null;

    public LinkTokenCreateRequestIncomeVerification incomeVerificationId(String incomeVerificationId) {
        this.incomeVerificationId = incomeVerificationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `income_verification_id` of the verification instance, as provided by `/income/verification/create`.")
    public String getIncomeVerificationId() {
        return this.incomeVerificationId;
    }

    public void setIncomeVerificationId(String incomeVerificationId) {
        this.incomeVerificationId = incomeVerificationId;
    }

    public LinkTokenCreateRequestIncomeVerification assetReportId(String assetReportId) {
        this.assetReportId = assetReportId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `asset_report_id` of an asset report associated with the user, as provided by `/asset_report/create`. Providing an `asset_report_id` is optional and can be used to verify the user through a streamlined flow. If provided, the bank linking flow will be skipped.")
    public String getAssetReportId() {
        return this.assetReportId;
    }

    public void setAssetReportId(String assetReportId) {
        this.assetReportId = assetReportId;
    }

    public LinkTokenCreateRequestIncomeVerification accessTokens(List<String> accessTokens) {
        this.accessTokens = accessTokens;
        return this;
    }

    public LinkTokenCreateRequestIncomeVerification addAccessTokensItem(String accessTokensItem) {
        if (this.accessTokens == null) {
            this.accessTokens = new ArrayList<String>();
        }
        this.accessTokens.add(accessTokensItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of access tokens corresponding to Items that a user has previously connected with. Data from these institutions will be cross-referenced with document data received during the Document Income flow to help verify that the uploaded documents are accurate. If the `transactions` product was not initialized for these Items during link, it will be initialized after this Link session.  This field should only be used with the `payroll` income source type.")
    public List<String> getAccessTokens() {
        return this.accessTokens;
    }

    public void setAccessTokens(List<String> accessTokens) {
        this.accessTokens = accessTokens;
    }

    public LinkTokenCreateRequestIncomeVerification incomeSourceTypes(List<IncomeVerificationSourceType> incomeSourceTypes) {
        this.incomeSourceTypes = incomeSourceTypes;
        return this;
    }

    public LinkTokenCreateRequestIncomeVerification addIncomeSourceTypesItem(IncomeVerificationSourceType incomeSourceTypesItem) {
        if (this.incomeSourceTypes == null) {
            this.incomeSourceTypes = new ArrayList<IncomeVerificationSourceType>();
        }
        this.incomeSourceTypes.add(incomeSourceTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The types of source income data that users will be permitted to share. Options include `bank` and `payroll`. Currently you can only specify one of these options.")
    public List<IncomeVerificationSourceType> getIncomeSourceTypes() {
        return this.incomeSourceTypes;
    }

    public void setIncomeSourceTypes(List<IncomeVerificationSourceType> incomeSourceTypes) {
        this.incomeSourceTypes = incomeSourceTypes;
    }

    public LinkTokenCreateRequestIncomeVerification bankIncome(LinkTokenCreateRequestIncomeVerificationBankIncome bankIncome) {
        this.bankIncome = bankIncome;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateRequestIncomeVerificationBankIncome getBankIncome() {
        return this.bankIncome;
    }

    public void setBankIncome(LinkTokenCreateRequestIncomeVerificationBankIncome bankIncome) {
        this.bankIncome = bankIncome;
    }

    public LinkTokenCreateRequestIncomeVerification payrollIncome(LinkTokenCreateRequestIncomeVerificationPayrollIncome payrollIncome) {
        this.payrollIncome = payrollIncome;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkTokenCreateRequestIncomeVerificationPayrollIncome getPayrollIncome() {
        return this.payrollIncome;
    }

    public void setPayrollIncome(LinkTokenCreateRequestIncomeVerificationPayrollIncome payrollIncome) {
        this.payrollIncome = payrollIncome;
    }

    public LinkTokenCreateRequestIncomeVerification statedIncomeSources(List<LinkTokenCreateRequestUserStatedIncomeSource> statedIncomeSources) {
        this.statedIncomeSources = statedIncomeSources;
        return this;
    }

    public LinkTokenCreateRequestIncomeVerification addStatedIncomeSourcesItem(LinkTokenCreateRequestUserStatedIncomeSource statedIncomeSourcesItem) {
        if (this.statedIncomeSources == null) {
            this.statedIncomeSources = new ArrayList<LinkTokenCreateRequestUserStatedIncomeSource>();
        }
        this.statedIncomeSources.add(statedIncomeSourcesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of user stated income sources")
    public List<LinkTokenCreateRequestUserStatedIncomeSource> getStatedIncomeSources() {
        return this.statedIncomeSources;
    }

    public void setStatedIncomeSources(List<LinkTokenCreateRequestUserStatedIncomeSource> statedIncomeSources) {
        this.statedIncomeSources = statedIncomeSources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkTokenCreateRequestIncomeVerification linkTokenCreateRequestIncomeVerification = (LinkTokenCreateRequestIncomeVerification)o;
        return Objects.equals(this.incomeVerificationId, linkTokenCreateRequestIncomeVerification.incomeVerificationId) && Objects.equals(this.assetReportId, linkTokenCreateRequestIncomeVerification.assetReportId) && Objects.equals(this.accessTokens, linkTokenCreateRequestIncomeVerification.accessTokens) && Objects.equals(this.incomeSourceTypes, linkTokenCreateRequestIncomeVerification.incomeSourceTypes) && Objects.equals(this.bankIncome, linkTokenCreateRequestIncomeVerification.bankIncome) && Objects.equals(this.payrollIncome, linkTokenCreateRequestIncomeVerification.payrollIncome) && Objects.equals(this.statedIncomeSources, linkTokenCreateRequestIncomeVerification.statedIncomeSources);
    }

    public int hashCode() {
        return Objects.hash(this.incomeVerificationId, this.assetReportId, this.accessTokens, this.incomeSourceTypes, this.bankIncome, this.payrollIncome, this.statedIncomeSources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkTokenCreateRequestIncomeVerification {\n");
        sb.append("    incomeVerificationId: ").append(this.toIndentedString(this.incomeVerificationId)).append("\n");
        sb.append("    assetReportId: ").append(this.toIndentedString(this.assetReportId)).append("\n");
        sb.append("    accessTokens: ").append(this.toIndentedString(this.accessTokens)).append("\n");
        sb.append("    incomeSourceTypes: ").append(this.toIndentedString(this.incomeSourceTypes)).append("\n");
        sb.append("    bankIncome: ").append(this.toIndentedString(this.bankIncome)).append("\n");
        sb.append("    payrollIncome: ").append(this.toIndentedString(this.payrollIncome)).append("\n");
        sb.append("    statedIncomeSources: ").append(this.toIndentedString(this.statedIncomeSources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

