/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IncomeVerificationDocParsingConfig;
import com.plaid.client.model.IncomeVerificationPayrollFlowType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specifies options for initializing Link for use with Payroll Income (including Document Income). Further customization options for Document Income, such as customizing which document types may be uploaded, are also available via the [Link Customization pane](https://dashboard.plaid.com/link) in the Dashboard. (Requires Production enablement.)")
public class LinkTokenCreateRequestIncomeVerificationPayrollIncome {
    public static final String SERIALIZED_NAME_FLOW_TYPES = "flow_types";
    @SerializedName(value="flow_types")
    private List<IncomeVerificationPayrollFlowType> flowTypes = null;
    public static final String SERIALIZED_NAME_IS_UPDATE_MODE = "is_update_mode";
    @SerializedName(value="is_update_mode")
    private Boolean isUpdateMode = false;
    public static final String SERIALIZED_NAME_ITEM_ID_TO_UPDATE = "item_id_to_update";
    @SerializedName(value="item_id_to_update")
    private String itemIdToUpdate;
    public static final String SERIALIZED_NAME_PARSING_CONFIG = "parsing_config";
    @SerializedName(value="parsing_config")
    private List<IncomeVerificationDocParsingConfig> parsingConfig = null;

    public LinkTokenCreateRequestIncomeVerificationPayrollIncome flowTypes(List<IncomeVerificationPayrollFlowType> flowTypes) {
        this.flowTypes = flowTypes;
        return this;
    }

    public LinkTokenCreateRequestIncomeVerificationPayrollIncome addFlowTypesItem(IncomeVerificationPayrollFlowType flowTypesItem) {
        if (this.flowTypes == null) {
            this.flowTypes = new ArrayList<IncomeVerificationPayrollFlowType>();
        }
        this.flowTypes.add(flowTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The types of payroll income verification to enable for the Link session. If none are specified, then users will see both document and digital payroll income.")
    public List<IncomeVerificationPayrollFlowType> getFlowTypes() {
        return this.flowTypes;
    }

    public void setFlowTypes(List<IncomeVerificationPayrollFlowType> flowTypes) {
        this.flowTypes = flowTypes;
    }

    public LinkTokenCreateRequestIncomeVerificationPayrollIncome isUpdateMode(Boolean isUpdateMode) {
        this.isUpdateMode = isUpdateMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An identifier to indicate whether the income verification Link token will be used for update mode. This field is only relevant for participants in the Payroll Income Refresh beta.")
    public Boolean getIsUpdateMode() {
        return this.isUpdateMode;
    }

    public void setIsUpdateMode(Boolean isUpdateMode) {
        this.isUpdateMode = isUpdateMode;
    }

    public LinkTokenCreateRequestIncomeVerificationPayrollIncome itemIdToUpdate(String itemIdToUpdate) {
        this.itemIdToUpdate = itemIdToUpdate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Uniquely identify a payroll income Item to update with.  This field is only relevant for participants in the Payroll Income Refresh beta.")
    public String getItemIdToUpdate() {
        return this.itemIdToUpdate;
    }

    public void setItemIdToUpdate(String itemIdToUpdate) {
        this.itemIdToUpdate = itemIdToUpdate;
    }

    public LinkTokenCreateRequestIncomeVerificationPayrollIncome parsingConfig(List<IncomeVerificationDocParsingConfig> parsingConfig) {
        this.parsingConfig = parsingConfig;
        return this;
    }

    public LinkTokenCreateRequestIncomeVerificationPayrollIncome addParsingConfigItem(IncomeVerificationDocParsingConfig parsingConfigItem) {
        if (this.parsingConfig == null) {
            this.parsingConfig = new ArrayList<IncomeVerificationDocParsingConfig>();
        }
        this.parsingConfig.add(parsingConfigItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The types of analysis to enable for document uploads. If this field is not provided, then docs will undergo OCR parsing only.")
    public List<IncomeVerificationDocParsingConfig> getParsingConfig() {
        return this.parsingConfig;
    }

    public void setParsingConfig(List<IncomeVerificationDocParsingConfig> parsingConfig) {
        this.parsingConfig = parsingConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkTokenCreateRequestIncomeVerificationPayrollIncome linkTokenCreateRequestIncomeVerificationPayrollIncome = (LinkTokenCreateRequestIncomeVerificationPayrollIncome)o;
        return Objects.equals(this.flowTypes, linkTokenCreateRequestIncomeVerificationPayrollIncome.flowTypes) && Objects.equals(this.isUpdateMode, linkTokenCreateRequestIncomeVerificationPayrollIncome.isUpdateMode) && Objects.equals(this.itemIdToUpdate, linkTokenCreateRequestIncomeVerificationPayrollIncome.itemIdToUpdate) && Objects.equals(this.parsingConfig, linkTokenCreateRequestIncomeVerificationPayrollIncome.parsingConfig);
    }

    public int hashCode() {
        return Objects.hash(this.flowTypes, this.isUpdateMode, this.itemIdToUpdate, this.parsingConfig);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkTokenCreateRequestIncomeVerificationPayrollIncome {\n");
        sb.append("    flowTypes: ").append(this.toIndentedString(this.flowTypes)).append("\n");
        sb.append("    isUpdateMode: ").append(this.toIndentedString(this.isUpdateMode)).append("\n");
        sb.append("    itemIdToUpdate: ").append(this.toIndentedString(this.itemIdToUpdate)).append("\n");
        sb.append("    parsingConfig: ").append(this.toIndentedString(this.parsingConfig)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

