/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specifies options for initializing Link for use with the Transfer product.")
public class LinkTokenCreateRequestTransfer {
    public static final String SERIALIZED_NAME_INTENT_ID = "intent_id";
    @SerializedName(value="intent_id")
    private String intentId;
    public static final String SERIALIZED_NAME_AUTHORIZATION_ID = "authorization_id";
    @SerializedName(value="authorization_id")
    private String authorizationId;
    public static final String SERIALIZED_NAME_PAYMENT_PROFILE_TOKEN = "payment_profile_token";
    @SerializedName(value="payment_profile_token")
    private String paymentProfileToken;

    public LinkTokenCreateRequestTransfer intentId(String intentId) {
        this.intentId = intentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `id` returned by the `/transfer/intent/create` endpoint.")
    public String getIntentId() {
        return this.intentId;
    }

    public void setIntentId(String intentId) {
        this.intentId = intentId;
    }

    public LinkTokenCreateRequestTransfer authorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `id` returned by the `/transfer/authorization/create` endpoint. Used to indicate Link session to complete required user action in order to make a decision for the authorization. If set, `access_token` can be omitted.")
    public String getAuthorizationId() {
        return this.authorizationId;
    }

    public void setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    public LinkTokenCreateRequestTransfer paymentProfileToken(String paymentProfileToken) {
        this.paymentProfileToken = paymentProfileToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `payment_profile_token` returned by the `/payment_profile/create` endpoint.")
    public String getPaymentProfileToken() {
        return this.paymentProfileToken;
    }

    public void setPaymentProfileToken(String paymentProfileToken) {
        this.paymentProfileToken = paymentProfileToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkTokenCreateRequestTransfer linkTokenCreateRequestTransfer = (LinkTokenCreateRequestTransfer)o;
        return Objects.equals(this.intentId, linkTokenCreateRequestTransfer.intentId) && Objects.equals(this.authorizationId, linkTokenCreateRequestTransfer.authorizationId) && Objects.equals(this.paymentProfileToken, linkTokenCreateRequestTransfer.paymentProfileToken);
    }

    public int hashCode() {
        return Objects.hash(this.intentId, this.authorizationId, this.paymentProfileToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkTokenCreateRequestTransfer {\n");
        sb.append("    intentId: ").append(this.toIndentedString(this.intentId)).append("\n");
        sb.append("    authorizationId: ").append(this.toIndentedString(this.authorizationId)).append("\n");
        sb.append("    paymentProfileToken: ").append(this.toIndentedString(this.paymentProfileToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

