/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specifies options for initializing Link for [update mode](https://plaid.com/docs/link/update-mode).")
public class LinkTokenCreateRequestUpdate {
    public static final String SERIALIZED_NAME_ACCOUNT_SELECTION_ENABLED = "account_selection_enabled";
    @SerializedName(value="account_selection_enabled")
    private Boolean accountSelectionEnabled = false;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private Boolean user = false;

    public LinkTokenCreateRequestUpdate accountSelectionEnabled(Boolean accountSelectionEnabled) {
        this.accountSelectionEnabled = accountSelectionEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If `true`, enables [update mode with Account Select](https://plaid.com/docs/link/update-mode/#using-update-mode-to-request-new-accounts) for institutions in the US and Canada that do not use OAuth, or that use OAuth but do not have their own account selection flow. For institutions in the US that have an OAuth account selection flow (i.e. most OAuth-enabled institutions), update mode with Account Select will always be enabled, regardless of the value of this field.")
    public Boolean getAccountSelectionEnabled() {
        return this.accountSelectionEnabled;
    }

    public void setAccountSelectionEnabled(Boolean accountSelectionEnabled) {
        this.accountSelectionEnabled = accountSelectionEnabled;
    }

    public LinkTokenCreateRequestUpdate user(Boolean user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If `true`, a `user_token` must also be provided, and Link will open in update mode for the given user.")
    public Boolean getUser() {
        return this.user;
    }

    public void setUser(Boolean user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkTokenCreateRequestUpdate linkTokenCreateRequestUpdate = (LinkTokenCreateRequestUpdate)o;
        return Objects.equals(this.accountSelectionEnabled, linkTokenCreateRequestUpdate.accountSelectionEnabled) && Objects.equals(this.user, linkTokenCreateRequestUpdate.user);
    }

    public int hashCode() {
        return Objects.hash(this.accountSelectionEnabled, this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkTokenCreateRequestUpdate {\n");
        sb.append("    accountSelectionEnabled: ").append(this.toIndentedString(this.accountSelectionEnabled)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

