/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IdentityVerificationRequestUserName;
import com.plaid.client.model.UserAddress;
import com.plaid.client.model.UserIDNumber;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object specifying information about the end user who will be linking their account.")
public class LinkTokenCreateRequestUser {
    public static final String SERIALIZED_NAME_CLIENT_USER_ID = "client_user_id";
    @SerializedName(value="client_user_id")
    private String clientUserId;
    public static final String SERIALIZED_NAME_LEGAL_NAME = "legal_name";
    @SerializedName(value="legal_name")
    private String legalName;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private IdentityVerificationRequestUserName name;
    public static final String SERIALIZED_NAME_PHONE_NUMBER = "phone_number";
    @SerializedName(value="phone_number")
    private String phoneNumber;
    public static final String SERIALIZED_NAME_PHONE_NUMBER_VERIFIED_TIME = "phone_number_verified_time";
    @SerializedName(value="phone_number_verified_time")
    private OffsetDateTime phoneNumberVerifiedTime;
    public static final String SERIALIZED_NAME_EMAIL_ADDRESS = "email_address";
    @SerializedName(value="email_address")
    private String emailAddress;
    public static final String SERIALIZED_NAME_EMAIL_ADDRESS_VERIFIED_TIME = "email_address_verified_time";
    @SerializedName(value="email_address_verified_time")
    private OffsetDateTime emailAddressVerifiedTime;
    public static final String SERIALIZED_NAME_SSN = "ssn";
    @SerializedName(value="ssn")
    private String ssn;
    public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "date_of_birth";
    @SerializedName(value="date_of_birth")
    private LocalDate dateOfBirth;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private UserAddress address;
    public static final String SERIALIZED_NAME_ID_NUMBER = "id_number";
    @SerializedName(value="id_number")
    private UserIDNumber idNumber;

    public LinkTokenCreateRequestUser clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique ID representing the end user. Typically this will be a user ID number from your application. Personally identifiable information, such as an email address or phone number, should not be used in the `client_user_id`. It is currently used as a means of searching logs for the given user in the Plaid Dashboard.")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public LinkTokenCreateRequestUser legalName(String legalName) {
        this.legalName = legalName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's full legal name, used for [micro-deposit based verification flows](https://plaid.com/docs/auth/coverage/). For a small number of customers on legacy flows, providing this field is required to enable micro-deposit-based flows. For all other customers, this field is optional. Providing the user's name in this field when using micro-deposit-based verification will streamline the end user experience, as the user will not be prompted to enter their name during the Link flow; Plaid will use the provided legal name instead.")
    public String getLegalName() {
        return this.legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public LinkTokenCreateRequestUser name(IdentityVerificationRequestUserName name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public IdentityVerificationRequestUserName getName() {
        return this.name;
    }

    public void setName(IdentityVerificationRequestUserName name) {
        this.name = name;
    }

    public LinkTokenCreateRequestUser phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. If supplied, will be used when applicable to prefill phone number fields in Link for the [returning user flow](https://www.plaid.com/docs/link/returning-user) and the [Identity Verification flow](https://www.plaid.com/docs/identity-verification).")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public LinkTokenCreateRequestUser phoneNumberVerifiedTime(OffsetDateTime phoneNumberVerifiedTime) {
        this.phoneNumberVerifiedTime = phoneNumberVerifiedTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date and time the phone number was verified in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDThh:mm:ssZ`). This was previously an optional field used in the [returning user experience](https://plaid.com/docs/link/returning-user). This field is no longer required to enable the returning user experience.   Only pass a verification time for a phone number that you have verified. If you have performed verification but don\u2019t have the time, you may supply a signal value of the start of the UNIX epoch.   Example: `2020-01-01T00:00:00Z` ")
    public OffsetDateTime getPhoneNumberVerifiedTime() {
        return this.phoneNumberVerifiedTime;
    }

    public void setPhoneNumberVerifiedTime(OffsetDateTime phoneNumberVerifiedTime) {
        this.phoneNumberVerifiedTime = phoneNumberVerifiedTime;
    }

    public LinkTokenCreateRequestUser emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's email address. Can be used to prefill Link fields when used with [Identity Verification](https://www.plaid.com/docs/identity-verification).")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public LinkTokenCreateRequestUser emailAddressVerifiedTime(OffsetDateTime emailAddressVerifiedTime) {
        this.emailAddressVerifiedTime = emailAddressVerifiedTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date and time the email address was verified in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDThh:mm:ssZ`). This was previously an optional field used in the [returning user experience](https://plaid.com/docs/link/returning-user). This field is no longer required to enable the returning user experience.   Only pass a verification time for an email address that you have verified. If you have performed verification but don\u2019t have the time, you may supply a signal value of the start of the UNIX epoch.   Example: `2020-01-01T00:00:00Z`")
    public OffsetDateTime getEmailAddressVerifiedTime() {
        return this.emailAddressVerifiedTime;
    }

    public void setEmailAddressVerifiedTime(OffsetDateTime emailAddressVerifiedTime) {
        this.emailAddressVerifiedTime = emailAddressVerifiedTime;
    }

    public LinkTokenCreateRequestUser ssn(String ssn) {
        this.ssn = ssn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated and not currently used, use the `id_number` field instead.")
    public String getSsn() {
        return this.ssn;
    }

    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

    public LinkTokenCreateRequestUser dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="To be provided in the format \"yyyy-mm-dd\". Can be used to prefill Link fields when used with Identity Verification.")
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public LinkTokenCreateRequestUser address(UserAddress address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UserAddress getAddress() {
        return this.address;
    }

    public void setAddress(UserAddress address) {
        this.address = address;
    }

    public LinkTokenCreateRequestUser idNumber(UserIDNumber idNumber) {
        this.idNumber = idNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UserIDNumber getIdNumber() {
        return this.idNumber;
    }

    public void setIdNumber(UserIDNumber idNumber) {
        this.idNumber = idNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkTokenCreateRequestUser linkTokenCreateRequestUser = (LinkTokenCreateRequestUser)o;
        return Objects.equals(this.clientUserId, linkTokenCreateRequestUser.clientUserId) && Objects.equals(this.legalName, linkTokenCreateRequestUser.legalName) && Objects.equals(this.name, linkTokenCreateRequestUser.name) && Objects.equals(this.phoneNumber, linkTokenCreateRequestUser.phoneNumber) && Objects.equals(this.phoneNumberVerifiedTime, linkTokenCreateRequestUser.phoneNumberVerifiedTime) && Objects.equals(this.emailAddress, linkTokenCreateRequestUser.emailAddress) && Objects.equals(this.emailAddressVerifiedTime, linkTokenCreateRequestUser.emailAddressVerifiedTime) && Objects.equals(this.ssn, linkTokenCreateRequestUser.ssn) && Objects.equals(this.dateOfBirth, linkTokenCreateRequestUser.dateOfBirth) && Objects.equals(this.address, linkTokenCreateRequestUser.address) && Objects.equals(this.idNumber, linkTokenCreateRequestUser.idNumber);
    }

    public int hashCode() {
        return Objects.hash(this.clientUserId, this.legalName, this.name, this.phoneNumber, this.phoneNumberVerifiedTime, this.emailAddress, this.emailAddressVerifiedTime, this.ssn, this.dateOfBirth, this.address, this.idNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkTokenCreateRequestUser {\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    phoneNumberVerifiedTime: ").append(this.toIndentedString(this.phoneNumberVerifiedTime)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    emailAddressVerifiedTime: ").append(this.toIndentedString(this.emailAddressVerifiedTime)).append("\n");
        sb.append("    ssn: ").append(this.toIndentedString(this.ssn)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    idNumber: ").append(this.toIndentedString(this.idNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

