/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.UserStatedIncomeSourceCategory;
import com.plaid.client.model.UserStatedIncomeSourceFrequency;
import com.plaid.client.model.UserStatedIncomeSourcePayType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specifies user stated income sources for the Income product")
public class LinkTokenCreateRequestUserStatedIncomeSource {
    public static final String SERIALIZED_NAME_EMPLOYER = "employer";
    @SerializedName(value="employer")
    private String employer;
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private UserStatedIncomeSourceCategory category;
    public static final String SERIALIZED_NAME_PAY_PER_CYCLE = "pay_per_cycle";
    @SerializedName(value="pay_per_cycle")
    private Double payPerCycle;
    public static final String SERIALIZED_NAME_PAY_ANNUAL = "pay_annual";
    @SerializedName(value="pay_annual")
    private Double payAnnual;
    public static final String SERIALIZED_NAME_PAY_TYPE = "pay_type";
    @SerializedName(value="pay_type")
    private UserStatedIncomeSourcePayType payType;
    public static final String SERIALIZED_NAME_PAY_FREQUENCY = "pay_frequency";
    @SerializedName(value="pay_frequency")
    private UserStatedIncomeSourceFrequency payFrequency;

    public LinkTokenCreateRequestUserStatedIncomeSource employer(String employer) {
        this.employer = employer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The employer corresponding to an income source specified by the user")
    public String getEmployer() {
        return this.employer;
    }

    public void setEmployer(String employer) {
        this.employer = employer;
    }

    public LinkTokenCreateRequestUserStatedIncomeSource category(UserStatedIncomeSourceCategory category) {
        this.category = category;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UserStatedIncomeSourceCategory getCategory() {
        return this.category;
    }

    public void setCategory(UserStatedIncomeSourceCategory category) {
        this.category = category;
    }

    public LinkTokenCreateRequestUserStatedIncomeSource payPerCycle(Double payPerCycle) {
        this.payPerCycle = payPerCycle;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The income amount paid per cycle for a specified income source")
    public Double getPayPerCycle() {
        return this.payPerCycle;
    }

    public void setPayPerCycle(Double payPerCycle) {
        this.payPerCycle = payPerCycle;
    }

    public LinkTokenCreateRequestUserStatedIncomeSource payAnnual(Double payAnnual) {
        this.payAnnual = payAnnual;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The income amount paid annually for a specified income source")
    public Double getPayAnnual() {
        return this.payAnnual;
    }

    public void setPayAnnual(Double payAnnual) {
        this.payAnnual = payAnnual;
    }

    public LinkTokenCreateRequestUserStatedIncomeSource payType(UserStatedIncomeSourcePayType payType) {
        this.payType = payType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UserStatedIncomeSourcePayType getPayType() {
        return this.payType;
    }

    public void setPayType(UserStatedIncomeSourcePayType payType) {
        this.payType = payType;
    }

    public LinkTokenCreateRequestUserStatedIncomeSource payFrequency(UserStatedIncomeSourceFrequency payFrequency) {
        this.payFrequency = payFrequency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UserStatedIncomeSourceFrequency getPayFrequency() {
        return this.payFrequency;
    }

    public void setPayFrequency(UserStatedIncomeSourceFrequency payFrequency) {
        this.payFrequency = payFrequency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkTokenCreateRequestUserStatedIncomeSource linkTokenCreateRequestUserStatedIncomeSource = (LinkTokenCreateRequestUserStatedIncomeSource)o;
        return Objects.equals(this.employer, linkTokenCreateRequestUserStatedIncomeSource.employer) && Objects.equals((Object)this.category, (Object)linkTokenCreateRequestUserStatedIncomeSource.category) && Objects.equals(this.payPerCycle, linkTokenCreateRequestUserStatedIncomeSource.payPerCycle) && Objects.equals(this.payAnnual, linkTokenCreateRequestUserStatedIncomeSource.payAnnual) && Objects.equals((Object)this.payType, (Object)linkTokenCreateRequestUserStatedIncomeSource.payType) && Objects.equals((Object)this.payFrequency, (Object)linkTokenCreateRequestUserStatedIncomeSource.payFrequency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.employer, this.category, this.payPerCycle, this.payAnnual, this.payType, this.payFrequency});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkTokenCreateRequestUserStatedIncomeSource {\n");
        sb.append("    employer: ").append(this.toIndentedString(this.employer)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    payPerCycle: ").append(this.toIndentedString(this.payPerCycle)).append("\n");
        sb.append("    payAnnual: ").append(this.toIndentedString(this.payAnnual)).append("\n");
        sb.append("    payType: ").append(this.toIndentedString((Object)this.payType)).append("\n");
        sb.append("    payFrequency: ").append(this.toIndentedString((Object)this.payFrequency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

