/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="LinkTokenCreateResponse defines the response schema for `/link/token/create`")
public class LinkTokenCreateResponse {
    public static final String SERIALIZED_NAME_LINK_TOKEN = "link_token";
    @SerializedName(value="link_token")
    private String linkToken;
    public static final String SERIALIZED_NAME_EXPIRATION = "expiration";
    @SerializedName(value="expiration")
    private OffsetDateTime expiration;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;
    public static final String SERIALIZED_NAME_HOSTED_LINK_URL = "hosted_link_url";
    @SerializedName(value="hosted_link_url")
    private String hostedLinkUrl;

    public LinkTokenCreateResponse linkToken(String linkToken) {
        this.linkToken = linkToken;
        return this;
    }

    @ApiModelProperty(required=true, value="A `link_token`, which can be supplied to Link in order to initialize it and receive a `public_token`, which can be exchanged for an `access_token`.")
    public String getLinkToken() {
        return this.linkToken;
    }

    public void setLinkToken(String linkToken) {
        this.linkToken = linkToken;
    }

    public LinkTokenCreateResponse expiration(OffsetDateTime expiration) {
        this.expiration = expiration;
        return this;
    }

    @ApiModelProperty(required=true, value="The expiration date for the `link_token`, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format. A `link_token` created to generate a `public_token` that will be exchanged for a new `access_token` expires after 4 hours. A `link_token` created for an existing Item (such as when updating an existing `access_token` by launching Link in update mode) expires after 30 minutes.")
    public OffsetDateTime getExpiration() {
        return this.expiration;
    }

    public void setExpiration(OffsetDateTime expiration) {
        this.expiration = expiration;
    }

    public LinkTokenCreateResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public LinkTokenCreateResponse hostedLinkUrl(String hostedLinkUrl) {
        this.hostedLinkUrl = hostedLinkUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A URL of a Plaid-hosted Link flow that will use the Link token returned by this request. Only present if the client is enabled for Hosted Link.")
    public String getHostedLinkUrl() {
        return this.hostedLinkUrl;
    }

    public void setHostedLinkUrl(String hostedLinkUrl) {
        this.hostedLinkUrl = hostedLinkUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkTokenCreateResponse linkTokenCreateResponse = (LinkTokenCreateResponse)o;
        return Objects.equals(this.linkToken, linkTokenCreateResponse.linkToken) && Objects.equals(this.expiration, linkTokenCreateResponse.expiration) && Objects.equals(this.requestId, linkTokenCreateResponse.requestId) && Objects.equals(this.hostedLinkUrl, linkTokenCreateResponse.hostedLinkUrl);
    }

    public int hashCode() {
        return Objects.hash(this.linkToken, this.expiration, this.requestId, this.hostedLinkUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkTokenCreateResponse {\n");
        sb.append("    linkToken: ").append(this.toIndentedString(this.linkToken)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    hostedLinkUrl: ").append(this.toIndentedString(this.hostedLinkUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

