/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="LinkTokenGetRequest defines the request schema for `/link/token/get`")
public class LinkTokenGetRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_LINK_TOKEN = "link_token";
    @SerializedName(value="link_token")
    private String linkToken;

    public LinkTokenGetRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public LinkTokenGetRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public LinkTokenGetRequest linkToken(String linkToken) {
        this.linkToken = linkToken;
        return this;
    }

    @ApiModelProperty(required=true, value="A `link_token` from a previous invocation of `/link/token/create`")
    public String getLinkToken() {
        return this.linkToken;
    }

    public void setLinkToken(String linkToken) {
        this.linkToken = linkToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkTokenGetRequest linkTokenGetRequest = (LinkTokenGetRequest)o;
        return Objects.equals(this.clientId, linkTokenGetRequest.clientId) && Objects.equals(this.secret, linkTokenGetRequest.secret) && Objects.equals(this.linkToken, linkTokenGetRequest.linkToken);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.linkToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkTokenGetRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    linkToken: ").append(this.toIndentedString(this.linkToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

