/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.LinkTokenGetMetadataResponse;
import com.plaid.client.model.LinkTokenGetSessionsResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="LinkTokenGetResponse defines the response schema for `/link/token/get`")
public class LinkTokenGetResponse {
    public static final String SERIALIZED_NAME_LINK_TOKEN = "link_token";
    @SerializedName(value="link_token")
    private String linkToken;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_EXPIRATION = "expiration";
    @SerializedName(value="expiration")
    private OffsetDateTime expiration;
    public static final String SERIALIZED_NAME_LINK_SESSIONS = "link_sessions";
    @SerializedName(value="link_sessions")
    private List<LinkTokenGetSessionsResponse> linkSessions = null;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private LinkTokenGetMetadataResponse metadata;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public LinkTokenGetResponse linkToken(String linkToken) {
        this.linkToken = linkToken;
        return this;
    }

    @ApiModelProperty(required=true, value="A `link_token`, which can be supplied to Link in order to initialize it and receive a `public_token`, which can be exchanged for an `access_token`.")
    public String getLinkToken() {
        return this.linkToken;
    }

    public void setLinkToken(String linkToken) {
        this.linkToken = linkToken;
    }

    public LinkTokenGetResponse createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The creation timestamp for the `link_token`, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public LinkTokenGetResponse expiration(OffsetDateTime expiration) {
        this.expiration = expiration;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The expiration timestamp for the `link_token`, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format.")
    public OffsetDateTime getExpiration() {
        return this.expiration;
    }

    public void setExpiration(OffsetDateTime expiration) {
        this.expiration = expiration;
    }

    public LinkTokenGetResponse linkSessions(List<LinkTokenGetSessionsResponse> linkSessions) {
        this.linkSessions = linkSessions;
        return this;
    }

    public LinkTokenGetResponse addLinkSessionsItem(LinkTokenGetSessionsResponse linkSessionsItem) {
        if (this.linkSessions == null) {
            this.linkSessions = new ArrayList<LinkTokenGetSessionsResponse>();
        }
        this.linkSessions.add(linkSessionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Information about Link sessions created using this `link_token`. Session data will be provided for up to six hours after the session has ended.")
    public List<LinkTokenGetSessionsResponse> getLinkSessions() {
        return this.linkSessions;
    }

    public void setLinkSessions(List<LinkTokenGetSessionsResponse> linkSessions) {
        this.linkSessions = linkSessions;
    }

    public LinkTokenGetResponse metadata(LinkTokenGetMetadataResponse metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public LinkTokenGetMetadataResponse getMetadata() {
        return this.metadata;
    }

    public void setMetadata(LinkTokenGetMetadataResponse metadata) {
        this.metadata = metadata;
    }

    public LinkTokenGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkTokenGetResponse linkTokenGetResponse = (LinkTokenGetResponse)o;
        return Objects.equals(this.linkToken, linkTokenGetResponse.linkToken) && Objects.equals(this.createdAt, linkTokenGetResponse.createdAt) && Objects.equals(this.expiration, linkTokenGetResponse.expiration) && Objects.equals(this.linkSessions, linkTokenGetResponse.linkSessions) && Objects.equals(this.metadata, linkTokenGetResponse.metadata) && Objects.equals(this.requestId, linkTokenGetResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.linkToken, this.createdAt, this.expiration, this.linkSessions, this.metadata, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkTokenGetResponse {\n");
        sb.append("    linkToken: ").append(this.toIndentedString(this.linkToken)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    linkSessions: ").append(this.toIndentedString(this.linkSessions)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

