/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.LinkEvent;
import com.plaid.client.model.LinkSessionExit;
import com.plaid.client.model.LinkSessionExitDeprecated;
import com.plaid.client.model.LinkSessionResults;
import com.plaid.client.model.LinkSessionSuccess;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object containing information about a link session. Session data will be provided for up to six hours after the session has ended.")
public class LinkTokenGetSessionsResponse {
    public static final String SERIALIZED_NAME_LINK_SESSION_ID = "link_session_id";
    @SerializedName(value="link_session_id")
    private String linkSessionId;
    public static final String SERIALIZED_NAME_STARTED_AT = "started_at";
    @SerializedName(value="started_at")
    private OffsetDateTime startedAt;
    public static final String SERIALIZED_NAME_FINISHED_AT = "finished_at";
    @SerializedName(value="finished_at")
    private OffsetDateTime finishedAt;
    public static final String SERIALIZED_NAME_ON_SUCCESS = "on_success";
    @SerializedName(value="on_success")
    private LinkSessionSuccess onSuccess;
    public static final String SERIALIZED_NAME_ON_EXIT = "on_exit";
    @SerializedName(value="on_exit")
    private LinkSessionExitDeprecated onExit;
    public static final String SERIALIZED_NAME_EXIT = "exit";
    @SerializedName(value="exit")
    private LinkSessionExit exit;
    public static final String SERIALIZED_NAME_EVENTS = "events";
    @SerializedName(value="events")
    private List<LinkEvent> events = null;
    public static final String SERIALIZED_NAME_RESULTS = "results";
    @SerializedName(value="results")
    private LinkSessionResults results;

    public LinkTokenGetSessionsResponse linkSessionId(String linkSessionId) {
        this.linkSessionId = linkSessionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique ID for the link session.")
    public String getLinkSessionId() {
        return this.linkSessionId;
    }

    public void setLinkSessionId(String linkSessionId) {
        this.linkSessionId = linkSessionId;
    }

    public LinkTokenGetSessionsResponse startedAt(OffsetDateTime startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The timestamp at which the link session was first started, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format.")
    public OffsetDateTime getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(OffsetDateTime startedAt) {
        this.startedAt = startedAt;
    }

    public LinkTokenGetSessionsResponse finishedAt(OffsetDateTime finishedAt) {
        this.finishedAt = finishedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The timestamp at which the link session was finished, if available, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format.")
    public OffsetDateTime getFinishedAt() {
        return this.finishedAt;
    }

    public void setFinishedAt(OffsetDateTime finishedAt) {
        this.finishedAt = finishedAt;
    }

    public LinkTokenGetSessionsResponse onSuccess(LinkSessionSuccess onSuccess) {
        this.onSuccess = onSuccess;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkSessionSuccess getOnSuccess() {
        return this.onSuccess;
    }

    public void setOnSuccess(LinkSessionSuccess onSuccess) {
        this.onSuccess = onSuccess;
    }

    public LinkTokenGetSessionsResponse onExit(LinkSessionExitDeprecated onExit) {
        this.onExit = onExit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkSessionExitDeprecated getOnExit() {
        return this.onExit;
    }

    public void setOnExit(LinkSessionExitDeprecated onExit) {
        this.onExit = onExit;
    }

    public LinkTokenGetSessionsResponse exit(LinkSessionExit exit) {
        this.exit = exit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkSessionExit getExit() {
        return this.exit;
    }

    public void setExit(LinkSessionExit exit) {
        this.exit = exit;
    }

    public LinkTokenGetSessionsResponse events(List<LinkEvent> events) {
        this.events = events;
        return this;
    }

    public LinkTokenGetSessionsResponse addEventsItem(LinkEvent eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<LinkEvent>();
        }
        this.events.add(eventsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of customer-related Link events")
    public List<LinkEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<LinkEvent> events) {
        this.events = events;
    }

    public LinkTokenGetSessionsResponse results(LinkSessionResults results) {
        this.results = results;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LinkSessionResults getResults() {
        return this.results;
    }

    public void setResults(LinkSessionResults results) {
        this.results = results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkTokenGetSessionsResponse linkTokenGetSessionsResponse = (LinkTokenGetSessionsResponse)o;
        return Objects.equals(this.linkSessionId, linkTokenGetSessionsResponse.linkSessionId) && Objects.equals(this.startedAt, linkTokenGetSessionsResponse.startedAt) && Objects.equals(this.finishedAt, linkTokenGetSessionsResponse.finishedAt) && Objects.equals(this.onSuccess, linkTokenGetSessionsResponse.onSuccess) && Objects.equals(this.onExit, linkTokenGetSessionsResponse.onExit) && Objects.equals(this.exit, linkTokenGetSessionsResponse.exit) && Objects.equals(this.events, linkTokenGetSessionsResponse.events) && Objects.equals(this.results, linkTokenGetSessionsResponse.results);
    }

    public int hashCode() {
        return Objects.hash(this.linkSessionId, this.startedAt, this.finishedAt, this.onSuccess, this.onExit, this.exit, this.events, this.results);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkTokenGetSessionsResponse {\n");
        sb.append("    linkSessionId: ").append(this.toIndentedString(this.linkSessionId)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("    finishedAt: ").append(this.toIndentedString(this.finishedAt)).append("\n");
        sb.append("    onSuccess: ").append(this.toIndentedString(this.onSuccess)).append("\n");
        sb.append("    onExit: ").append(this.toIndentedString(this.onExit)).append("\n");
        sb.append("    exit: ").append(this.toIndentedString(this.exit)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

