/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Configuration parameters for the Investments product")
public class LinkTokenInvestments {
    public static final String SERIALIZED_NAME_ALLOW_UNVERIFIED_CRYPTO_WALLETS = "allow_unverified_crypto_wallets";
    @SerializedName(value="allow_unverified_crypto_wallets")
    private Boolean allowUnverifiedCryptoWallets;
    public static final String SERIALIZED_NAME_ALLOW_MANUAL_ENTRY = "allow_manual_entry";
    @SerializedName(value="allow_manual_entry")
    private Boolean allowManualEntry;

    public LinkTokenInvestments allowUnverifiedCryptoWallets(Boolean allowUnverifiedCryptoWallets) {
        this.allowUnverifiedCryptoWallets = allowUnverifiedCryptoWallets;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If `true`, allow self-custody crypto wallets to be added without requiring signature verification. Defaults to `false`.")
    public Boolean getAllowUnverifiedCryptoWallets() {
        return this.allowUnverifiedCryptoWallets;
    }

    public void setAllowUnverifiedCryptoWallets(Boolean allowUnverifiedCryptoWallets) {
        this.allowUnverifiedCryptoWallets = allowUnverifiedCryptoWallets;
    }

    public LinkTokenInvestments allowManualEntry(Boolean allowManualEntry) {
        this.allowManualEntry = allowManualEntry;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If `true`, allow users to manually enter Investments account and holdings information. Defaults to `false`.")
    public Boolean getAllowManualEntry() {
        return this.allowManualEntry;
    }

    public void setAllowManualEntry(Boolean allowManualEntry) {
        this.allowManualEntry = allowManualEntry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkTokenInvestments linkTokenInvestments = (LinkTokenInvestments)o;
        return Objects.equals(this.allowUnverifiedCryptoWallets, linkTokenInvestments.allowUnverifiedCryptoWallets) && Objects.equals(this.allowManualEntry, linkTokenInvestments.allowManualEntry);
    }

    public int hashCode() {
        return Objects.hash(this.allowUnverifiedCryptoWallets, this.allowManualEntry);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkTokenInvestments {\n");
        sb.append("    allowUnverifiedCryptoWallets: ").append(this.toIndentedString(this.allowUnverifiedCryptoWallets)).append("\n");
        sb.append("    allowManualEntry: ").append(this.toIndentedString(this.allowManualEntry)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

