/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.LinkDeliveryMetadata;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Webhook indicating that the status of the delivery of the Hosted Link session to a user")
public class LinkUserDeliveryStatusWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_LINK_DELIVERY_SESSION_ID = "link_delivery_session_id";
    @SerializedName(value="link_delivery_session_id")
    private String linkDeliverySessionId;
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private String timestamp;
    public static final String SERIALIZED_NAME_LINK_DELIVERY_METADATA = "link_delivery_metadata";
    @SerializedName(value="link_delivery_metadata")
    private LinkDeliveryMetadata linkDeliveryMetadata;

    public LinkUserDeliveryStatusWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`LINK_DELIVERY`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public LinkUserDeliveryStatusWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`DELIVERY_STATUS`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public LinkUserDeliveryStatusWebhook linkDeliverySessionId(String linkDeliverySessionId) {
        this.linkDeliverySessionId = linkDeliverySessionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the Hosted Link session.")
    public String getLinkDeliverySessionId() {
        return this.linkDeliverySessionId;
    }

    public void setLinkDeliverySessionId(String linkDeliverySessionId) {
        this.linkDeliverySessionId = linkDeliverySessionId;
    }

    public LinkUserDeliveryStatusWebhook timestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(required=true, value="Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format.")
    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public LinkUserDeliveryStatusWebhook linkDeliveryMetadata(LinkDeliveryMetadata linkDeliveryMetadata) {
        this.linkDeliveryMetadata = linkDeliveryMetadata;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public LinkDeliveryMetadata getLinkDeliveryMetadata() {
        return this.linkDeliveryMetadata;
    }

    public void setLinkDeliveryMetadata(LinkDeliveryMetadata linkDeliveryMetadata) {
        this.linkDeliveryMetadata = linkDeliveryMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkUserDeliveryStatusWebhook linkUserDeliveryStatusWebhook = (LinkUserDeliveryStatusWebhook)o;
        return Objects.equals(this.webhookType, linkUserDeliveryStatusWebhook.webhookType) && Objects.equals(this.webhookCode, linkUserDeliveryStatusWebhook.webhookCode) && Objects.equals(this.linkDeliverySessionId, linkUserDeliveryStatusWebhook.linkDeliverySessionId) && Objects.equals(this.timestamp, linkUserDeliveryStatusWebhook.timestamp) && Objects.equals(this.linkDeliveryMetadata, linkUserDeliveryStatusWebhook.linkDeliveryMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.webhookType, this.webhookCode, this.linkDeliverySessionId, this.timestamp, this.linkDeliveryMetadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkUserDeliveryStatusWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    linkDeliverySessionId: ").append(this.toIndentedString(this.linkDeliverySessionId)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    linkDeliveryMetadata: ").append(this.toIndentedString(this.linkDeliveryMetadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

