/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A representation of where a transaction took place")
public class Location {
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private String address;
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_REGION = "region";
    @SerializedName(value="region")
    private String region;
    public static final String SERIALIZED_NAME_POSTAL_CODE = "postal_code";
    @SerializedName(value="postal_code")
    private String postalCode;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;
    public static final String SERIALIZED_NAME_LAT = "lat";
    @SerializedName(value="lat")
    private Double lat;
    public static final String SERIALIZED_NAME_LON = "lon";
    @SerializedName(value="lon")
    private Double lon;
    public static final String SERIALIZED_NAME_STORE_NUMBER = "store_number";
    @SerializedName(value="store_number")
    private String storeNumber;

    public Location address(String address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The street address where the transaction occurred.")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Location city(String city) {
        this.city = city;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The city where the transaction occurred.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Location region(String region) {
        this.region = region;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The region or state where the transaction occurred. In API versions 2018-05-22 and earlier, this field is called `state`.")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Location postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The postal code where the transaction occurred. In API versions 2018-05-22 and earlier, this field is called `zip`.")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Location country(String country) {
        this.country = country;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ISO 3166-1 alpha-2 country code where the transaction occurred.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public Location lat(Double lat) {
        this.lat = lat;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The latitude where the transaction occurred.")
    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Location lon(Double lon) {
        this.lon = lon;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The longitude where the transaction occurred.")
    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    public Location storeNumber(String storeNumber) {
        this.storeNumber = storeNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The merchant defined store number where the transaction occurred.")
    public String getStoreNumber() {
        return this.storeNumber;
    }

    public void setStoreNumber(String storeNumber) {
        this.storeNumber = storeNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        return Objects.equals(this.address, location.address) && Objects.equals(this.city, location.city) && Objects.equals(this.region, location.region) && Objects.equals(this.postalCode, location.postalCode) && Objects.equals(this.country, location.country) && Objects.equals(this.lat, location.lat) && Objects.equals(this.lon, location.lon) && Objects.equals(this.storeNumber, location.storeNumber);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.city, this.region, this.postalCode, this.country, this.lat, this.lon, this.storeNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Location {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    lat: ").append(this.toIndentedString(this.lat)).append("\n");
        sb.append("    lon: ").append(this.toIndentedString(this.lon)).append("\n");
        sb.append("    storeNumber: ").append(this.toIndentedString(this.storeNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

