/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Specifies the multi-factor authentication settings to use with this test account")
public class MFA {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_QUESTION_ROUNDS = "question_rounds";
    @SerializedName(value="question_rounds")
    private Double questionRounds;
    public static final String SERIALIZED_NAME_QUESTIONS_PER_ROUND = "questions_per_round";
    @SerializedName(value="questions_per_round")
    private Double questionsPerRound;
    public static final String SERIALIZED_NAME_SELECTION_ROUNDS = "selection_rounds";
    @SerializedName(value="selection_rounds")
    private Double selectionRounds;
    public static final String SERIALIZED_NAME_SELECTIONS_PER_QUESTION = "selections_per_question";
    @SerializedName(value="selections_per_question")
    private Double selectionsPerQuestion;

    public MFA type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Possible values are `device`, `selections`, or `questions`.  If value is `device`, the MFA answer is `1234`.  If value is `selections`, the MFA answer is always the first option.  If value is `questions`, the MFA answer is  `answer_<i>_<j>` for the j-th question in the i-th round, starting from 0. For example, the answer to the first question in the second round is `answer_1_0`.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public MFA questionRounds(Double questionRounds) {
        this.questionRounds = questionRounds;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of rounds of questions. Required if value of `type` is `questions`. ")
    public Double getQuestionRounds() {
        return this.questionRounds;
    }

    public void setQuestionRounds(Double questionRounds) {
        this.questionRounds = questionRounds;
    }

    public MFA questionsPerRound(Double questionsPerRound) {
        this.questionsPerRound = questionsPerRound;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of questions per round. Required if value of `type` is `questions`. If value of type is `selections`, default value is 2.")
    public Double getQuestionsPerRound() {
        return this.questionsPerRound;
    }

    public void setQuestionsPerRound(Double questionsPerRound) {
        this.questionsPerRound = questionsPerRound;
    }

    public MFA selectionRounds(Double selectionRounds) {
        this.selectionRounds = selectionRounds;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of rounds of selections, used if `type` is `selections`. Defaults to 1.")
    public Double getSelectionRounds() {
        return this.selectionRounds;
    }

    public void setSelectionRounds(Double selectionRounds) {
        this.selectionRounds = selectionRounds;
    }

    public MFA selectionsPerQuestion(Double selectionsPerQuestion) {
        this.selectionsPerQuestion = selectionsPerQuestion;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of available answers per question, used if `type` is `selection`. Defaults to 2. ")
    public Double getSelectionsPerQuestion() {
        return this.selectionsPerQuestion;
    }

    public void setSelectionsPerQuestion(Double selectionsPerQuestion) {
        this.selectionsPerQuestion = selectionsPerQuestion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MFA MFA2 = (MFA)o;
        return Objects.equals(this.type, MFA2.type) && Objects.equals(this.questionRounds, MFA2.questionRounds) && Objects.equals(this.questionsPerRound, MFA2.questionsPerRound) && Objects.equals(this.selectionRounds, MFA2.selectionRounds) && Objects.equals(this.selectionsPerQuestion, MFA2.selectionsPerQuestion);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.questionRounds, this.questionsPerRound, this.selectionRounds, this.selectionsPerQuestion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MFA {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    questionRounds: ").append(this.toIndentedString(this.questionRounds)).append("\n");
        sb.append("    questionsPerRound: ").append(this.toIndentedString(this.questionsPerRound)).append("\n");
        sb.append("    selectionRounds: ").append(this.toIndentedString(this.selectionRounds)).append("\n");
        sb.append("    selectionsPerQuestion: ").append(this.toIndentedString(this.selectionsPerQuestion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

