/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Insights into a user\u2019s top merchants.")
public class MerchantInsights {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_ENTITY_ID = "entity_id";
    @SerializedName(value="entity_id")
    private String entityId;
    public static final String SERIALIZED_NAME_WEBSITE = "website";
    @SerializedName(value="website")
    private String website;
    public static final String SERIALIZED_NAME_TRANSACTION_COUNT = "transaction_count";
    @SerializedName(value="transaction_count")
    private Integer transactionCount;
    public static final String SERIALIZED_NAME_PERSONAL_FINANCE_CATEGORY_PRIMARY = "personal_finance_category_primary";
    @SerializedName(value="personal_finance_category_primary")
    private String personalFinanceCategoryPrimary;
    public static final String SERIALIZED_NAME_PERSONAL_FINANCE_CATEGORY_DETAILED = "personal_finance_category_detailed";
    @SerializedName(value="personal_finance_category_detailed")
    private String personalFinanceCategoryDetailed;
    public static final String SERIALIZED_NAME_TOTAL_OUTFLOWS = "total_outflows";
    @SerializedName(value="total_outflows")
    private Double totalOutflows;
    public static final String SERIALIZED_NAME_TOTAL_INFLOWS = "total_inflows";
    @SerializedName(value="total_inflows")
    private Double totalInflows;

    public MerchantInsights name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The counterparty name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MerchantInsights entityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique, stable, Plaid-generated id that maps to the merchant.")
    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public MerchantInsights website(String website) {
        this.website = website;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The website associated with the merchant.")
    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public MerchantInsights transactionCount(Integer transactionCount) {
        this.transactionCount = transactionCount;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of transactions associated with merchant of this type.")
    public Integer getTransactionCount() {
        return this.transactionCount;
    }

    public void setTransactionCount(Integer transactionCount) {
        this.transactionCount = transactionCount;
    }

    public MerchantInsights personalFinanceCategoryPrimary(String personalFinanceCategoryPrimary) {
        this.personalFinanceCategoryPrimary = personalFinanceCategoryPrimary;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The primary personal finance category associated with this merchant.")
    public String getPersonalFinanceCategoryPrimary() {
        return this.personalFinanceCategoryPrimary;
    }

    public void setPersonalFinanceCategoryPrimary(String personalFinanceCategoryPrimary) {
        this.personalFinanceCategoryPrimary = personalFinanceCategoryPrimary;
    }

    public MerchantInsights personalFinanceCategoryDetailed(String personalFinanceCategoryDetailed) {
        this.personalFinanceCategoryDetailed = personalFinanceCategoryDetailed;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The detailed personal finance category associated with this merchant.")
    public String getPersonalFinanceCategoryDetailed() {
        return this.personalFinanceCategoryDetailed;
    }

    public void setPersonalFinanceCategoryDetailed(String personalFinanceCategoryDetailed) {
        this.personalFinanceCategoryDetailed = personalFinanceCategoryDetailed;
    }

    public MerchantInsights totalOutflows(Double totalOutflows) {
        this.totalOutflows = totalOutflows;
        return this;
    }

    @ApiModelProperty(required=true, value="Sum of outflow amounts.")
    public Double getTotalOutflows() {
        return this.totalOutflows;
    }

    public void setTotalOutflows(Double totalOutflows) {
        this.totalOutflows = totalOutflows;
    }

    public MerchantInsights totalInflows(Double totalInflows) {
        this.totalInflows = totalInflows;
        return this;
    }

    @ApiModelProperty(required=true, value="Sum of inflow amounts.")
    public Double getTotalInflows() {
        return this.totalInflows;
    }

    public void setTotalInflows(Double totalInflows) {
        this.totalInflows = totalInflows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerchantInsights merchantInsights = (MerchantInsights)o;
        return Objects.equals(this.name, merchantInsights.name) && Objects.equals(this.entityId, merchantInsights.entityId) && Objects.equals(this.website, merchantInsights.website) && Objects.equals(this.transactionCount, merchantInsights.transactionCount) && Objects.equals(this.personalFinanceCategoryPrimary, merchantInsights.personalFinanceCategoryPrimary) && Objects.equals(this.personalFinanceCategoryDetailed, merchantInsights.personalFinanceCategoryDetailed) && Objects.equals(this.totalOutflows, merchantInsights.totalOutflows) && Objects.equals(this.totalInflows, merchantInsights.totalInflows);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.entityId, this.website, this.transactionCount, this.personalFinanceCategoryPrimary, this.personalFinanceCategoryDetailed, this.totalOutflows, this.totalInflows);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerchantInsights {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    entityId: ").append(this.toIndentedString(this.entityId)).append("\n");
        sb.append("    website: ").append(this.toIndentedString(this.website)).append("\n");
        sb.append("    transactionCount: ").append(this.toIndentedString(this.transactionCount)).append("\n");
        sb.append("    personalFinanceCategoryPrimary: ").append(this.toIndentedString(this.personalFinanceCategoryPrimary)).append("\n");
        sb.append("    personalFinanceCategoryDetailed: ").append(this.toIndentedString(this.personalFinanceCategoryDetailed)).append("\n");
        sb.append("    totalOutflows: ").append(this.toIndentedString(this.totalOutflows)).append("\n");
        sb.append("    totalInflows: ").append(this.toIndentedString(this.totalInflows)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

