/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Allows specifying the metadata of the test account")
public class Meta {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_OFFICIAL_NAME = "official_name";
    @SerializedName(value="official_name")
    private String officialName;
    public static final String SERIALIZED_NAME_LIMIT = "limit";
    @SerializedName(value="limit")
    private Double limit;
    public static final String SERIALIZED_NAME_MASK = "mask";
    @SerializedName(value="mask")
    private String mask;

    public Meta name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The account's name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Meta officialName(String officialName) {
        this.officialName = officialName;
        return this;
    }

    @ApiModelProperty(required=true, value="The account's official name")
    public String getOfficialName() {
        return this.officialName;
    }

    public void setOfficialName(String officialName) {
        this.officialName = officialName;
    }

    public Meta limit(Double limit) {
        this.limit = limit;
        return this;
    }

    @ApiModelProperty(required=true, value="The account's limit")
    public Double getLimit() {
        return this.limit;
    }

    public void setLimit(Double limit) {
        this.limit = limit;
    }

    public Meta mask(String mask) {
        this.mask = mask;
        return this;
    }

    @ApiModelProperty(required=true, value="The account's mask. Should be an empty string or a string of 2-4 alphanumeric characters. This allows you to model a mask which does not match the account number (such as with a virtual account number).")
    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Meta meta = (Meta)o;
        return Objects.equals(this.name, meta.name) && Objects.equals(this.officialName, meta.officialName) && Objects.equals(this.limit, meta.limit) && Objects.equals(this.mask, meta.mask);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.officialName, this.limit, this.mask);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Meta {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    officialName: ").append(this.toIndentedString(this.officialName)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    mask: ").append(this.toIndentedString(this.mask)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

