/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object containing metadata about the interest rate for the mortgage.")
public class MortgageInterestRate {
    public static final String SERIALIZED_NAME_PERCENTAGE = "percentage";
    @SerializedName(value="percentage")
    private Double percentage;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public MortgageInterestRate percentage(Double percentage) {
        this.percentage = percentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Percentage value (interest rate of current mortgage, not APR) of interest payable on a loan.")
    public Double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(Double percentage) {
        this.percentage = percentage;
    }

    public MortgageInterestRate type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The type of interest charged (fixed or variable).")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MortgageInterestRate mortgageInterestRate = (MortgageInterestRate)o;
        return Objects.equals(this.percentage, mortgageInterestRate.percentage) && Objects.equals(this.type, mortgageInterestRate.type);
    }

    public int hashCode() {
        return Objects.hash(this.percentage, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MortgageInterestRate {\n");
        sb.append("    percentage: ").append(this.toIndentedString(this.percentage)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

