/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.MortgageInterestRate;
import com.plaid.client.model.MortgagePropertyAddress;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Contains details about a mortgage account.")
public class MortgageLiability {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_CURRENT_LATE_FEE = "current_late_fee";
    @SerializedName(value="current_late_fee")
    private Double currentLateFee;
    public static final String SERIALIZED_NAME_ESCROW_BALANCE = "escrow_balance";
    @SerializedName(value="escrow_balance")
    private Double escrowBalance;
    public static final String SERIALIZED_NAME_HAS_PMI = "has_pmi";
    @SerializedName(value="has_pmi")
    private Boolean hasPmi;
    public static final String SERIALIZED_NAME_HAS_PREPAYMENT_PENALTY = "has_prepayment_penalty";
    @SerializedName(value="has_prepayment_penalty")
    private Boolean hasPrepaymentPenalty;
    public static final String SERIALIZED_NAME_INTEREST_RATE = "interest_rate";
    @SerializedName(value="interest_rate")
    private MortgageInterestRate interestRate;
    public static final String SERIALIZED_NAME_LAST_PAYMENT_AMOUNT = "last_payment_amount";
    @SerializedName(value="last_payment_amount")
    private Double lastPaymentAmount;
    public static final String SERIALIZED_NAME_LAST_PAYMENT_DATE = "last_payment_date";
    @SerializedName(value="last_payment_date")
    private LocalDate lastPaymentDate;
    public static final String SERIALIZED_NAME_LOAN_TYPE_DESCRIPTION = "loan_type_description";
    @SerializedName(value="loan_type_description")
    private String loanTypeDescription;
    public static final String SERIALIZED_NAME_LOAN_TERM = "loan_term";
    @SerializedName(value="loan_term")
    private String loanTerm;
    public static final String SERIALIZED_NAME_MATURITY_DATE = "maturity_date";
    @SerializedName(value="maturity_date")
    private LocalDate maturityDate;
    public static final String SERIALIZED_NAME_NEXT_MONTHLY_PAYMENT = "next_monthly_payment";
    @SerializedName(value="next_monthly_payment")
    private Double nextMonthlyPayment;
    public static final String SERIALIZED_NAME_NEXT_PAYMENT_DUE_DATE = "next_payment_due_date";
    @SerializedName(value="next_payment_due_date")
    private LocalDate nextPaymentDueDate;
    public static final String SERIALIZED_NAME_ORIGINATION_DATE = "origination_date";
    @SerializedName(value="origination_date")
    private LocalDate originationDate;
    public static final String SERIALIZED_NAME_ORIGINATION_PRINCIPAL_AMOUNT = "origination_principal_amount";
    @SerializedName(value="origination_principal_amount")
    private Double originationPrincipalAmount;
    public static final String SERIALIZED_NAME_PAST_DUE_AMOUNT = "past_due_amount";
    @SerializedName(value="past_due_amount")
    private Double pastDueAmount;
    public static final String SERIALIZED_NAME_PROPERTY_ADDRESS = "property_address";
    @SerializedName(value="property_address")
    private MortgagePropertyAddress propertyAddress;
    public static final String SERIALIZED_NAME_YTD_INTEREST_PAID = "ytd_interest_paid";
    @SerializedName(value="ytd_interest_paid")
    private Double ytdInterestPaid;
    public static final String SERIALIZED_NAME_YTD_PRINCIPAL_PAID = "ytd_principal_paid";
    @SerializedName(value="ytd_principal_paid")
    private Double ytdPrincipalPaid;

    public MortgageLiability accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the account that this liability belongs to.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public MortgageLiability accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The account number of the loan.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public MortgageLiability currentLateFee(Double currentLateFee) {
        this.currentLateFee = currentLateFee;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The current outstanding amount charged for late payment.")
    public Double getCurrentLateFee() {
        return this.currentLateFee;
    }

    public void setCurrentLateFee(Double currentLateFee) {
        this.currentLateFee = currentLateFee;
    }

    public MortgageLiability escrowBalance(Double escrowBalance) {
        this.escrowBalance = escrowBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Total amount held in escrow to pay taxes and insurance on behalf of the borrower.")
    public Double getEscrowBalance() {
        return this.escrowBalance;
    }

    public void setEscrowBalance(Double escrowBalance) {
        this.escrowBalance = escrowBalance;
    }

    public MortgageLiability hasPmi(Boolean hasPmi) {
        this.hasPmi = hasPmi;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Indicates whether the borrower has private mortgage insurance in effect.")
    public Boolean getHasPmi() {
        return this.hasPmi;
    }

    public void setHasPmi(Boolean hasPmi) {
        this.hasPmi = hasPmi;
    }

    public MortgageLiability hasPrepaymentPenalty(Boolean hasPrepaymentPenalty) {
        this.hasPrepaymentPenalty = hasPrepaymentPenalty;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Indicates whether the borrower will pay a penalty for early payoff of mortgage.")
    public Boolean getHasPrepaymentPenalty() {
        return this.hasPrepaymentPenalty;
    }

    public void setHasPrepaymentPenalty(Boolean hasPrepaymentPenalty) {
        this.hasPrepaymentPenalty = hasPrepaymentPenalty;
    }

    public MortgageLiability interestRate(MortgageInterestRate interestRate) {
        this.interestRate = interestRate;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public MortgageInterestRate getInterestRate() {
        return this.interestRate;
    }

    public void setInterestRate(MortgageInterestRate interestRate) {
        this.interestRate = interestRate;
    }

    public MortgageLiability lastPaymentAmount(Double lastPaymentAmount) {
        this.lastPaymentAmount = lastPaymentAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The amount of the last payment.")
    public Double getLastPaymentAmount() {
        return this.lastPaymentAmount;
    }

    public void setLastPaymentAmount(Double lastPaymentAmount) {
        this.lastPaymentAmount = lastPaymentAmount;
    }

    public MortgageLiability lastPaymentDate(LocalDate lastPaymentDate) {
        this.lastPaymentDate = lastPaymentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The date of the last payment. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).")
    public LocalDate getLastPaymentDate() {
        return this.lastPaymentDate;
    }

    public void setLastPaymentDate(LocalDate lastPaymentDate) {
        this.lastPaymentDate = lastPaymentDate;
    }

    public MortgageLiability loanTypeDescription(String loanTypeDescription) {
        this.loanTypeDescription = loanTypeDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Description of the type of loan, for example `conventional`, `fixed`, or `variable`. This field is provided directly from the loan servicer and does not have an enumerated set of possible values.")
    public String getLoanTypeDescription() {
        return this.loanTypeDescription;
    }

    public void setLoanTypeDescription(String loanTypeDescription) {
        this.loanTypeDescription = loanTypeDescription;
    }

    public MortgageLiability loanTerm(String loanTerm) {
        this.loanTerm = loanTerm;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Full duration of mortgage as at origination (e.g. `10 year`).")
    public String getLoanTerm() {
        return this.loanTerm;
    }

    public void setLoanTerm(String loanTerm) {
        this.loanTerm = loanTerm;
    }

    public MortgageLiability maturityDate(LocalDate maturityDate) {
        this.maturityDate = maturityDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Original date on which mortgage is due in full. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).")
    public LocalDate getMaturityDate() {
        return this.maturityDate;
    }

    public void setMaturityDate(LocalDate maturityDate) {
        this.maturityDate = maturityDate;
    }

    public MortgageLiability nextMonthlyPayment(Double nextMonthlyPayment) {
        this.nextMonthlyPayment = nextMonthlyPayment;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The amount of the next payment.")
    public Double getNextMonthlyPayment() {
        return this.nextMonthlyPayment;
    }

    public void setNextMonthlyPayment(Double nextMonthlyPayment) {
        this.nextMonthlyPayment = nextMonthlyPayment;
    }

    public MortgageLiability nextPaymentDueDate(LocalDate nextPaymentDueDate) {
        this.nextPaymentDueDate = nextPaymentDueDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The due date for the next payment. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).")
    public LocalDate getNextPaymentDueDate() {
        return this.nextPaymentDueDate;
    }

    public void setNextPaymentDueDate(LocalDate nextPaymentDueDate) {
        this.nextPaymentDueDate = nextPaymentDueDate;
    }

    public MortgageLiability originationDate(LocalDate originationDate) {
        this.originationDate = originationDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The date on which the loan was initially lent. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).")
    public LocalDate getOriginationDate() {
        return this.originationDate;
    }

    public void setOriginationDate(LocalDate originationDate) {
        this.originationDate = originationDate;
    }

    public MortgageLiability originationPrincipalAmount(Double originationPrincipalAmount) {
        this.originationPrincipalAmount = originationPrincipalAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The original principal balance of the mortgage.")
    public Double getOriginationPrincipalAmount() {
        return this.originationPrincipalAmount;
    }

    public void setOriginationPrincipalAmount(Double originationPrincipalAmount) {
        this.originationPrincipalAmount = originationPrincipalAmount;
    }

    public MortgageLiability pastDueAmount(Double pastDueAmount) {
        this.pastDueAmount = pastDueAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Amount of loan (principal + interest) past due for payment.")
    public Double getPastDueAmount() {
        return this.pastDueAmount;
    }

    public void setPastDueAmount(Double pastDueAmount) {
        this.pastDueAmount = pastDueAmount;
    }

    public MortgageLiability propertyAddress(MortgagePropertyAddress propertyAddress) {
        this.propertyAddress = propertyAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public MortgagePropertyAddress getPropertyAddress() {
        return this.propertyAddress;
    }

    public void setPropertyAddress(MortgagePropertyAddress propertyAddress) {
        this.propertyAddress = propertyAddress;
    }

    public MortgageLiability ytdInterestPaid(Double ytdInterestPaid) {
        this.ytdInterestPaid = ytdInterestPaid;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The year to date (YTD) interest paid.")
    public Double getYtdInterestPaid() {
        return this.ytdInterestPaid;
    }

    public void setYtdInterestPaid(Double ytdInterestPaid) {
        this.ytdInterestPaid = ytdInterestPaid;
    }

    public MortgageLiability ytdPrincipalPaid(Double ytdPrincipalPaid) {
        this.ytdPrincipalPaid = ytdPrincipalPaid;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The YTD principal paid.")
    public Double getYtdPrincipalPaid() {
        return this.ytdPrincipalPaid;
    }

    public void setYtdPrincipalPaid(Double ytdPrincipalPaid) {
        this.ytdPrincipalPaid = ytdPrincipalPaid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MortgageLiability mortgageLiability = (MortgageLiability)o;
        return Objects.equals(this.accountId, mortgageLiability.accountId) && Objects.equals(this.accountNumber, mortgageLiability.accountNumber) && Objects.equals(this.currentLateFee, mortgageLiability.currentLateFee) && Objects.equals(this.escrowBalance, mortgageLiability.escrowBalance) && Objects.equals(this.hasPmi, mortgageLiability.hasPmi) && Objects.equals(this.hasPrepaymentPenalty, mortgageLiability.hasPrepaymentPenalty) && Objects.equals(this.interestRate, mortgageLiability.interestRate) && Objects.equals(this.lastPaymentAmount, mortgageLiability.lastPaymentAmount) && Objects.equals(this.lastPaymentDate, mortgageLiability.lastPaymentDate) && Objects.equals(this.loanTypeDescription, mortgageLiability.loanTypeDescription) && Objects.equals(this.loanTerm, mortgageLiability.loanTerm) && Objects.equals(this.maturityDate, mortgageLiability.maturityDate) && Objects.equals(this.nextMonthlyPayment, mortgageLiability.nextMonthlyPayment) && Objects.equals(this.nextPaymentDueDate, mortgageLiability.nextPaymentDueDate) && Objects.equals(this.originationDate, mortgageLiability.originationDate) && Objects.equals(this.originationPrincipalAmount, mortgageLiability.originationPrincipalAmount) && Objects.equals(this.pastDueAmount, mortgageLiability.pastDueAmount) && Objects.equals(this.propertyAddress, mortgageLiability.propertyAddress) && Objects.equals(this.ytdInterestPaid, mortgageLiability.ytdInterestPaid) && Objects.equals(this.ytdPrincipalPaid, mortgageLiability.ytdPrincipalPaid);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.accountNumber, this.currentLateFee, this.escrowBalance, this.hasPmi, this.hasPrepaymentPenalty, this.interestRate, this.lastPaymentAmount, this.lastPaymentDate, this.loanTypeDescription, this.loanTerm, this.maturityDate, this.nextMonthlyPayment, this.nextPaymentDueDate, this.originationDate, this.originationPrincipalAmount, this.pastDueAmount, this.propertyAddress, this.ytdInterestPaid, this.ytdPrincipalPaid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MortgageLiability {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    currentLateFee: ").append(this.toIndentedString(this.currentLateFee)).append("\n");
        sb.append("    escrowBalance: ").append(this.toIndentedString(this.escrowBalance)).append("\n");
        sb.append("    hasPmi: ").append(this.toIndentedString(this.hasPmi)).append("\n");
        sb.append("    hasPrepaymentPenalty: ").append(this.toIndentedString(this.hasPrepaymentPenalty)).append("\n");
        sb.append("    interestRate: ").append(this.toIndentedString(this.interestRate)).append("\n");
        sb.append("    lastPaymentAmount: ").append(this.toIndentedString(this.lastPaymentAmount)).append("\n");
        sb.append("    lastPaymentDate: ").append(this.toIndentedString(this.lastPaymentDate)).append("\n");
        sb.append("    loanTypeDescription: ").append(this.toIndentedString(this.loanTypeDescription)).append("\n");
        sb.append("    loanTerm: ").append(this.toIndentedString(this.loanTerm)).append("\n");
        sb.append("    maturityDate: ").append(this.toIndentedString(this.maturityDate)).append("\n");
        sb.append("    nextMonthlyPayment: ").append(this.toIndentedString(this.nextMonthlyPayment)).append("\n");
        sb.append("    nextPaymentDueDate: ").append(this.toIndentedString(this.nextPaymentDueDate)).append("\n");
        sb.append("    originationDate: ").append(this.toIndentedString(this.originationDate)).append("\n");
        sb.append("    originationPrincipalAmount: ").append(this.toIndentedString(this.originationPrincipalAmount)).append("\n");
        sb.append("    pastDueAmount: ").append(this.toIndentedString(this.pastDueAmount)).append("\n");
        sb.append("    propertyAddress: ").append(this.toIndentedString(this.propertyAddress)).append("\n");
        sb.append("    ytdInterestPaid: ").append(this.toIndentedString(this.ytdInterestPaid)).append("\n");
        sb.append("    ytdPrincipalPaid: ").append(this.toIndentedString(this.ytdPrincipalPaid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

