/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.DocumentRiskSignal;
import com.plaid.client.model.RiskSignalDocumentReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Object containing risk signals and relevant metadata for a set of uploaded documents")
public class MultiDocumentRiskSignal {
    public static final String SERIALIZED_NAME_DOCUMENT_REFERENCES = "document_references";
    @SerializedName(value="document_references")
    private List<RiskSignalDocumentReference> documentReferences = new ArrayList<RiskSignalDocumentReference>();
    public static final String SERIALIZED_NAME_RISK_SIGNALS = "risk_signals";
    @SerializedName(value="risk_signals")
    private List<DocumentRiskSignal> riskSignals = new ArrayList<DocumentRiskSignal>();

    public MultiDocumentRiskSignal documentReferences(List<RiskSignalDocumentReference> documentReferences) {
        this.documentReferences = documentReferences;
        return this;
    }

    public MultiDocumentRiskSignal addDocumentReferencesItem(RiskSignalDocumentReference documentReferencesItem) {
        this.documentReferences.add(documentReferencesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of objects containing attributes that could indicate if a document is fraudulent")
    public List<RiskSignalDocumentReference> getDocumentReferences() {
        return this.documentReferences;
    }

    public void setDocumentReferences(List<RiskSignalDocumentReference> documentReferences) {
        this.documentReferences = documentReferences;
    }

    public MultiDocumentRiskSignal riskSignals(List<DocumentRiskSignal> riskSignals) {
        this.riskSignals = riskSignals;
        return this;
    }

    public MultiDocumentRiskSignal addRiskSignalsItem(DocumentRiskSignal riskSignalsItem) {
        this.riskSignals.add(riskSignalsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of attributes that indicate whether or not there is fraud risk with a set of documents")
    public List<DocumentRiskSignal> getRiskSignals() {
        return this.riskSignals;
    }

    public void setRiskSignals(List<DocumentRiskSignal> riskSignals) {
        this.riskSignals = riskSignals;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiDocumentRiskSignal multiDocumentRiskSignal = (MultiDocumentRiskSignal)o;
        return Objects.equals(this.documentReferences, multiDocumentRiskSignal.documentReferences) && Objects.equals(this.riskSignals, multiDocumentRiskSignal.riskSignals);
    }

    public int hashCode() {
        return Objects.hash(this.documentReferences, this.riskSignals);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MultiDocumentRiskSignal {\n");
        sb.append("    documentReferences: ").append(this.toIndentedString(this.documentReferences)).append("\n");
        sb.append("    riskSignals: ").append(this.toIndentedString(this.riskSignals)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

