/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Score found by matching name provided by the API with the name on the account at the financial institution. If the account contains multiple owners, the maximum match score is filled.")
public class NameMatchScore {
    public static final String SERIALIZED_NAME_SCORE = "score";
    @SerializedName(value="score")
    private Integer score;
    public static final String SERIALIZED_NAME_IS_FIRST_NAME_OR_LAST_NAME_MATCH = "is_first_name_or_last_name_match";
    @SerializedName(value="is_first_name_or_last_name_match")
    private Boolean isFirstNameOrLastNameMatch;
    public static final String SERIALIZED_NAME_IS_NICKNAME_MATCH = "is_nickname_match";
    @SerializedName(value="is_nickname_match")
    private Boolean isNicknameMatch;
    public static final String SERIALIZED_NAME_IS_BUSINESS_NAME_DETECTED = "is_business_name_detected";
    @SerializedName(value="is_business_name_detected")
    private Boolean isBusinessNameDetected;

    public NameMatchScore score(Integer score) {
        this.score = score;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Match score for name. 100 is a perfect score, 99-85 means a strong match, 84-70 is a partial match, any score less than 70 is a mismatch. Typically, the match threshold should be set to a score of 70 or higher. If the name is missing from either the API or financial institution, this is null.")
    public Integer getScore() {
        return this.score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public NameMatchScore isFirstNameOrLastNameMatch(Boolean isFirstNameOrLastNameMatch) {
        this.isFirstNameOrLastNameMatch = isFirstNameOrLastNameMatch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="first or last name completely matched, likely a family member")
    public Boolean getIsFirstNameOrLastNameMatch() {
        return this.isFirstNameOrLastNameMatch;
    }

    public void setIsFirstNameOrLastNameMatch(Boolean isFirstNameOrLastNameMatch) {
        this.isFirstNameOrLastNameMatch = isFirstNameOrLastNameMatch;
    }

    public NameMatchScore isNicknameMatch(Boolean isNicknameMatch) {
        this.isNicknameMatch = isNicknameMatch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="nickname matched, example Jennifer and Jenn.")
    public Boolean getIsNicknameMatch() {
        return this.isNicknameMatch;
    }

    public void setIsNicknameMatch(Boolean isNicknameMatch) {
        this.isNicknameMatch = isNicknameMatch;
    }

    public NameMatchScore isBusinessNameDetected(Boolean isBusinessNameDetected) {
        this.isBusinessNameDetected = isBusinessNameDetected;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Is `true` if the name on either of the names that was matched for the score contained strings indicative of a business name, such as \"CORP\", \"LLC\", \"INC\", or \"LTD\". A `true` result generally indicates the entity is a business. However, a `false` result does not mean the entity is not a business, as some businesses do not use these strings in the names used for their financial institution accounts.")
    public Boolean getIsBusinessNameDetected() {
        return this.isBusinessNameDetected;
    }

    public void setIsBusinessNameDetected(Boolean isBusinessNameDetected) {
        this.isBusinessNameDetected = isBusinessNameDetected;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NameMatchScore nameMatchScore = (NameMatchScore)o;
        return Objects.equals(this.score, nameMatchScore.score) && Objects.equals(this.isFirstNameOrLastNameMatch, nameMatchScore.isFirstNameOrLastNameMatch) && Objects.equals(this.isNicknameMatch, nameMatchScore.isNicknameMatch) && Objects.equals(this.isBusinessNameDetected, nameMatchScore.isBusinessNameDetected);
    }

    public int hashCode() {
        return Objects.hash(this.score, this.isFirstNameOrLastNameMatch, this.isNicknameMatch, this.isBusinessNameDetected);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NameMatchScore {\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("    isFirstNameOrLastNameMatch: ").append(this.toIndentedString(this.isFirstNameOrLastNameMatch)).append("\n");
        sb.append("    isNicknameMatch: ").append(this.toIndentedString(this.isNicknameMatch)).append("\n");
        sb.append("    isBusinessNameDetected: ").append(this.toIndentedString(this.isBusinessNameDetected)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

