/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Account and bank identifier number data used to configure the test account. All values are optional.")
public class Numbers {
    public static final String SERIALIZED_NAME_ACCOUNT = "account";
    @SerializedName(value="account")
    private String account;
    public static final String SERIALIZED_NAME_ACH_ROUTING = "ach_routing";
    @SerializedName(value="ach_routing")
    private String achRouting;
    public static final String SERIALIZED_NAME_ACH_WIRE_ROUTING = "ach_wire_routing";
    @SerializedName(value="ach_wire_routing")
    private String achWireRouting;
    public static final String SERIALIZED_NAME_EFT_INSTITUTION = "eft_institution";
    @SerializedName(value="eft_institution")
    private String eftInstitution;
    public static final String SERIALIZED_NAME_EFT_BRANCH = "eft_branch";
    @SerializedName(value="eft_branch")
    private String eftBranch;
    public static final String SERIALIZED_NAME_INTERNATIONAL_BIC = "international_bic";
    @SerializedName(value="international_bic")
    private String internationalBic;
    public static final String SERIALIZED_NAME_INTERNATIONAL_IBAN = "international_iban";
    @SerializedName(value="international_iban")
    private String internationalIban;
    public static final String SERIALIZED_NAME_BACS_SORT_CODE = "bacs_sort_code";
    @SerializedName(value="bacs_sort_code")
    private String bacsSortCode;

    public Numbers account(String account) {
        this.account = account;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Will be used for the account number.")
    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public Numbers achRouting(String achRouting) {
        this.achRouting = achRouting;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Must be a valid ACH routing number. To test `/transfer/capabilities/get`, set this to 322271627 to force a `true` result.")
    public String getAchRouting() {
        return this.achRouting;
    }

    public void setAchRouting(String achRouting) {
        this.achRouting = achRouting;
    }

    public Numbers achWireRouting(String achWireRouting) {
        this.achWireRouting = achWireRouting;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Must be a valid wire transfer routing number.")
    public String getAchWireRouting() {
        return this.achWireRouting;
    }

    public void setAchWireRouting(String achWireRouting) {
        this.achWireRouting = achWireRouting;
    }

    public Numbers eftInstitution(String eftInstitution) {
        this.eftInstitution = eftInstitution;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EFT institution number. Must be specified alongside `eft_branch`.")
    public String getEftInstitution() {
        return this.eftInstitution;
    }

    public void setEftInstitution(String eftInstitution) {
        this.eftInstitution = eftInstitution;
    }

    public Numbers eftBranch(String eftBranch) {
        this.eftBranch = eftBranch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EFT branch number. Must be specified alongside `eft_institution`.")
    public String getEftBranch() {
        return this.eftBranch;
    }

    public void setEftBranch(String eftBranch) {
        this.eftBranch = eftBranch;
    }

    public Numbers internationalBic(String internationalBic) {
        this.internationalBic = internationalBic;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Bank identifier code (BIC). Must be specified alongside `international_iban`.")
    public String getInternationalBic() {
        return this.internationalBic;
    }

    public void setInternationalBic(String internationalBic) {
        this.internationalBic = internationalBic;
    }

    public Numbers internationalIban(String internationalIban) {
        this.internationalIban = internationalIban;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="International bank account number (IBAN). If no account number is specified via `account`, will also be used as the account number by default. Must be specified alongside `international_bic`.")
    public String getInternationalIban() {
        return this.internationalIban;
    }

    public void setInternationalIban(String internationalIban) {
        this.internationalIban = internationalIban;
    }

    public Numbers bacsSortCode(String bacsSortCode) {
        this.bacsSortCode = bacsSortCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BACS sort code")
    public String getBacsSortCode() {
        return this.bacsSortCode;
    }

    public void setBacsSortCode(String bacsSortCode) {
        this.bacsSortCode = bacsSortCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Numbers numbers = (Numbers)o;
        return Objects.equals(this.account, numbers.account) && Objects.equals(this.achRouting, numbers.achRouting) && Objects.equals(this.achWireRouting, numbers.achWireRouting) && Objects.equals(this.eftInstitution, numbers.eftInstitution) && Objects.equals(this.eftBranch, numbers.eftBranch) && Objects.equals(this.internationalBic, numbers.internationalBic) && Objects.equals(this.internationalIban, numbers.internationalIban) && Objects.equals(this.bacsSortCode, numbers.bacsSortCode);
    }

    public int hashCode() {
        return Objects.hash(this.account, this.achRouting, this.achWireRouting, this.eftInstitution, this.eftBranch, this.internationalBic, this.internationalIban, this.bacsSortCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Numbers {\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    achRouting: ").append(this.toIndentedString(this.achRouting)).append("\n");
        sb.append("    achWireRouting: ").append(this.toIndentedString(this.achWireRouting)).append("\n");
        sb.append("    eftInstitution: ").append(this.toIndentedString(this.eftInstitution)).append("\n");
        sb.append("    eftBranch: ").append(this.toIndentedString(this.eftBranch)).append("\n");
        sb.append("    internationalBic: ").append(this.toIndentedString(this.internationalBic)).append("\n");
        sb.append("    internationalIban: ").append(this.toIndentedString(this.internationalIban)).append("\n");
        sb.append("    bacsSortCode: ").append(this.toIndentedString(this.bacsSortCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

